package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by Wi1ls on 2016/12/14;
 */
public class CustomAttachmentPhoneCallSystemNotice extends CustomAttachment {
    private static final String TYPE_NOTICE = "type_notice";

    private String msgType;//根据此字段显示不同文字  1：邀请开通  2：留言

    public CustomAttachmentPhoneCallSystemNotice() {
        super(CustomAttachmentType.TYPE_PHONE_CALL_SYSTEM_NOTICE);
    }

    public CustomAttachmentPhoneCallSystemNotice(String msgType) {
        super(CustomAttachmentType.TYPE_PHONE_CALL_SYSTEM_NOTICE);
        this.msgType = msgType;
    }

    @Override
    protected void parseData(JSONObject data) {
        msgType = data.getString(TYPE_NOTICE);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(TYPE_NOTICE, msgType);
        return data;
    }

    public String getMsgType() {
        return msgType;
    }

    /**
     * 是否是 邀请开通 消息
     * @return
     */
    public boolean isInviteMessage() {
        return msgType.equals("1");
    }

    /**
     * 是否是 留言 消息
     * @return
     */
    public boolean isLeaveMessage() {
        return msgType.equals("2");
    }
}
