package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;

/**
 * 后台推送到收款状态，比如超时未支付
 * Created by harvie on 2017/1/13.
 */

public class CustomAttachmentReceivedTimeout extends CustomAttachment {
    private static final String KEY_FROM_CONTENT = "from_content";
    private static final String KEY_FROM_UID = "from_uid";
    private static final String KEY_TO_CONTENT = "to_content";
    private static final String KEY_TO_UID = "touid";
    private static final String KEY_POCKET_ID="orderid";

    private String from_content ="";
    private String from_uid = "";
    private String to_content = "";
    private String touid = "";
    private String orderid = "";

    public CustomAttachmentReceivedTimeout() {
        super(CustomAttachmentType.RECEIVEDMONEY_TIMEOUT);
    }

    @Override
    protected void parseData(JSONObject data) {
        from_content = data.getString(KEY_FROM_CONTENT);
        from_uid = data.getString(KEY_FROM_UID);
        to_content = data.getString(KEY_TO_CONTENT);
        touid = data.getString(KEY_TO_UID);
        orderid=data.getString(KEY_POCKET_ID);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(KEY_FROM_CONTENT, from_content);
        data.put(KEY_FROM_UID, from_uid);
        data.put(KEY_TO_CONTENT, to_content);
        data.put(KEY_TO_UID, touid);
        data.put(KEY_POCKET_ID,orderid);
        return data;
    }

    public String getFrom_content() {
        return from_content;
    }

    public String getFrom_uid() {
        return from_uid;
    }

    public String getTo_content() {
        return to_content;
    }

    public String getTouid() {
        return touid;
    }

    public String getOrderid() {
        return orderid;
    }
}
