package com.yidianling.im.session.extension;

import com.alibaba.fastjson.JSONObject;
import com.yidianling.im.session.enums.ShareMsgTypeEnum;

/**
 * Created by haorui on 2019-11-06 .
 * Des: 分享消息 拓展
 */
public class CustomAttachmentShareMsg extends CustomAttachment {

    private final String KEY_SHARETYPE="shareType";// 分享的类型，0：测试；1，课程；2，文章；3：倾诉
    private final String KEY_SHAREPICURL="sharePicUrl";// 分享的图片
    private final String KEY_SHARETITLE="shareTitle";// 分享的title
    private final String KEY_SHAREAUTHOR="shareAuthor";// 分享的作者
    private final String KEY_SHAREREADED="shareReaded";// 分享的阅读数
    private final String KEY_SHARETESTED="shareTested";// 分享的测试数
    private final String KEY_PRICE="price";// 价格
    private final String KEY_THEWAY="theWay";// 方式
    private final String KEY_DURATION="duration";// 时长
    private final String KEY_SHAREPOPULAR="sharePopular";// 分享的人气
    private final String KEY_SHARE_JUMP_URL="url";// 分享的跳转链接

    private String shareUrl;
    private String sharePrice;
    //分享类型，0：测试；1，课程；2，文章；3：倾诉
    private int shareType;

    public CustomAttachmentShareMsg() {
        super(CustomAttachmentType.TYPE_PUSH_SHARE);
    }

    public CustomAttachmentShareMsg(String url, String money, ShareMsgTypeEnum typeEnum) {
        super(CustomAttachmentType.TYPE_PUSH_SHARE);
        this.shareUrl = url;
        this.sharePrice = money;
        this.shareType = typeEnum.value();
    }

    @Override
    protected void parseData(JSONObject data) {
        this.shareUrl=data.getString(KEY_SHARE_JUMP_URL);
        this.sharePrice =data.getString(KEY_PRICE);
        this.shareType = data.getInteger(KEY_SHARETYPE);
    }

    @Override
    protected JSONObject packData() {
        JSONObject data = new JSONObject();
        data.put(KEY_SHARE_JUMP_URL, shareUrl);
        data.put(KEY_PRICE, sharePrice);
        data.put(KEY_SHARETYPE, shareType);
        return data;
    }

    public String getShareUrl() {
        return shareUrl;
    }

    public String getSharePrice() {
        return sharePrice;
    }

    public int getShareType() {
        return shareType;
    }
}
