package com.yidianling.im.session.viewholder;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.ydl.ydl_image.module.GlideApp;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachmentBusinessCard;
import com.yidianling.im.session.viewholder.adapter.AdapterBusinessCard;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author huozhiliang
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2020/9/7
 */
public class MsgViewHolderBusinessCard extends MsgViewHolderBase {

    private ImageView expertImg;
    private TextView expertSecondTitle;
    private TextView expertName;
    private TextView scoreExpert;
    private TextView commentCount;
    private TextView cerfiticateYear;
    private TextView serviceCount;
    private TextView serviceTime;
    private RecyclerView recy;
    private AdapterBusinessCard businessCard;

    private LinearLayout m_im_ll_feedbackRate;
    private String urlJump = "";//跳转URL字段

    public MsgViewHolderBusinessCard(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_custom_business_card;
    }

    @Override
    protected void inflateContentView() {
        expertImg = findViewById(R.id.expert_Img);
        expertSecondTitle = findViewById(R.id.expertSecondTitle);
        expertName = findViewById(R.id.expertName);
        scoreExpert = findViewById(R.id.scoreExpert);
        commentCount = findViewById(R.id.commentCount);
        cerfiticateYear = findViewById(R.id.cerfiticateYear);
        serviceCount = findViewById(R.id.serviceCount);
        serviceTime = findViewById(R.id.serviceTime);
        recy = findViewById(R.id.expertTagRV);
        m_im_ll_feedbackRate = findViewById(R.id.m_ll_feedbackRate);
    }

    @Override
    protected void bindContentView() {
        CustomAttachmentBusinessCard customBusinessCard = (CustomAttachmentBusinessCard) message.getAttachment();
        businessCard = new AdapterBusinessCard();
        businessCard.setTagData(new ArrayList<String>());
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context);
        linearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
        recy.setLayoutManager(linearLayoutManager);
        recy.setAdapter(businessCard);
        GlideApp.with(context).load(customBusinessCard.expertImg)
                .into(expertImg);
        String tags = customBusinessCard.tagList;
        List<String> tagsList = Arrays.asList(tags.split("\\|"));
        businessCard.setTagData(tagsList);
        expertName.setText(customBusinessCard.name);
        expertSecondTitle.setText(customBusinessCard.secondTitle);
        scoreExpert.setText(customBusinessCard.feedbackRate.toString().substring(0,3));
        scoreExpert.invalidate();
        commentCount.setText(customBusinessCard.commentNum + "人评价");
        cerfiticateYear.setText(customBusinessCard.workYears);
        serviceCount.setText(customBusinessCard.orderNum);
        serviceTime.setText(customBusinessCard.helpLong);
        urlJump = customBusinessCard.doctorCardUrl;


        m_im_ll_feedbackRate.removeAllViews();
        for (int j = 1; j <= 5; j++) {
            View view = LayoutInflater.from(context).inflate(
                    R.layout.m_im_feedbackrate,
                    m_im_ll_feedbackRate,
                    false
            );

            ImageView startIMG = view.findViewById(R.id.feedBackRate);
            if (customBusinessCard.feedbackRate >= j) {
                startIMG.setBackground(context.getResources().getDrawable(R.drawable.m_im_full_star));
            } else if (customBusinessCard.feedbackRate < j && customBusinessCard.feedbackRate > j - 1) {
                startIMG.setBackground(context.getResources().getDrawable(R.drawable.m_im_half_star));
            } else {
                //UI没切这个emptyStar的图，所以只能用之前的星星，墨刀很难用
                startIMG.setBackground(context.getResources().getDrawable(R.drawable.m_im_nothing_star));
            }
            m_im_ll_feedbackRate.addView(view);
        }
    }

    @Override
    protected void onItemClick() {
        super.onItemClick();
        if (null != urlJump && !urlJump.isEmpty()) {
            NewH5Activity.start(context, new H5Params(urlJump, "专家名片"));
        } else {
            LogUtil.e("doctorCardUrl:" + urlJump);
        }
    }
}
