package com.yidianling.im.session.viewholder;

import androidx.core.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.yidianling.im.R;
import com.yidianling.im.config.constants.ImConstants;
import com.yidianling.im.session.extension.CustomAttachConsultSubScript;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

/**
 * author : harvie
 * 确认咨询预约消息
 */

public class MsgViewHolderConsultSubScribe extends MsgViewHolderBase {

    private TextView tv_title,tv_content,tv_date,tv_time_long,tv_type,tv_package;
    private ImageView img_icon;
    private View lin_root;

    public String title; //自定义消息标题
    public String productName;//商品名称
    public String consultDate;//咨询时间
    public String consultTime;//咨询时长
    public String consultType;//咨询方式
    public String url;//跳转url
    public int flag;//0 未确认 1已确认
    public byte isPackage;
    /***新订单id*/
    public String newOrderId;

    public MsgViewHolderConsultSubScribe(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_custom_consult_subscribe;
    }

    @Override
    protected void inflateContentView() {
        lin_root = view.findViewById(R.id.lin_root);
        tv_title = view.findViewById(R.id.tv_title);
        tv_content = view.findViewById(R.id.tv_content);
        tv_date = view.findViewById(R.id.tv_date);
        tv_time_long = view.findViewById(R.id.tv_time_long);
        tv_type = view.findViewById(R.id.tv_type);
        img_icon = view.findViewById(R.id.img_icon);
        tv_package = view.findViewById(R.id.tv_package);

        if (isReceivedMessage()){
            setAvatarRightInVisibity();
            lin_root.setBackgroundResource(R.drawable.im_bg_radius_no_topleft_white_8);
        }else {
            setAvatarLeftInVisibity();
            lin_root.setBackgroundResource(R.drawable.im_bg_radius_no_topright_white_8);
        }
    }

    @Override
    protected void bindContentView() {

        if (isReceivedMessage()){
            setAvatarRightInVisibity();
        }else {
            setAvatarLeftInVisibity();
        }

        MsgAttachment attachment = message.getAttachment();
        if (attachment instanceof CustomAttachConsultSubScript) {
            title = ((CustomAttachConsultSubScript) attachment).title;
            productName = ((CustomAttachConsultSubScript) attachment).productName;
            consultDate = ((CustomAttachConsultSubScript) attachment).consultDate;
            consultTime = ((CustomAttachConsultSubScript) attachment).consultTime;
            consultType = ((CustomAttachConsultSubScript) attachment).consultType;
            url = ((CustomAttachConsultSubScript) attachment).url;
            flag = ((CustomAttachConsultSubScript) attachment).flag;
            isPackage = ((CustomAttachConsultSubScript) attachment).isPackage;
            newOrderId = ((CustomAttachConsultSubScript) attachment).newOrderId;
        }

        tv_title.setText(title);
        tv_date.setText(consultDate);
        tv_time_long.setText(consultTime);
        tv_type.setText(consultType);

        if (isPackage == 2){
            tv_package.setVisibility(View.VISIBLE);
            tv_content.setText("\u3000\u3000"+productName);
        }else {
            tv_package.setVisibility(View.GONE);
            tv_content.setText(productName);
        }

        if (flag==1){
            img_icon.setVisibility(View.VISIBLE);
            tv_title.setTextColor(ContextCompat.getColor(context,R.color.im_color_00CC88));
        }else {
            img_icon.setVisibility(View.GONE);
            tv_title.setTextColor(ContextCompat.getColor(context,R.color.platform_color_242424));
        }

        hideItemBg();
    }

    @Override
    protected void onItemClick() {
        if (TextUtils.isEmpty(url)&& newOrderId == null){
            return;
        }

        if (newOrderId == null || newOrderId.isEmpty()) {
            NewH5Activity.start(context, new H5Params(url, null));
        } else {
            //跳转新订单详情页
            H5Params orderParams = new H5Params(
                    ImConstants.Companion.getORDER_DETAIL() + (newOrderId.isEmpty() ? "" : newOrderId), null);
            NewH5Activity.start(context, orderParams);
        }
    }
}
