package com.yidianling.im.session.viewholder;

import android.widget.ImageView;

import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.ydl.ydl_image.module.GlideApp;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachLingxiFirstQuestion;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.activity.WatchVideoActivity;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;

public class MsgViewHolderLingxiFirstQuestion extends MsgViewHolderBase {
    private ImageView imageView;
    private String jumpUrl;
    private String jumpVideo;
    private String imageUrl;

    public MsgViewHolderLingxiFirstQuestion(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_nim_lingxi_first_question;
    }

    @Override
    protected void inflateContentView() {
        imageView=findViewById(R.id.first_question);
    }

    @Override
    protected void bindContentView() {
        jumpUrl=((CustomAttachLingxiFirstQuestion) message.getAttachment()).greetUrl;
        jumpVideo=((CustomAttachLingxiFirstQuestion) message.getAttachment()).greetVideo;
        imageUrl=((CustomAttachLingxiFirstQuestion) message.getAttachment()).greetImage;
        GlideApp.with(context)
                .load(imageUrl)
                .into(imageView);
    }

    @Override
    protected void onItemClick() {
        super.onItemClick();
        if (jumpUrl.length()>0&&jumpUrl!=null){
            //跳转URL
            NewH5Activity.start(context,new H5Params(jumpUrl,null));
        }/* else if (jumpVideo!=null&&!jumpVideo.isEmpty()){
            //播放视频
            NewH5Activity.start(context,new H5Params(jumpVideo,null));
        }*/
    }
}
