package com.yidianling.im.session.viewholder;

import android.widget.TextView;

import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachModifyTime;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/04
 */

public class MsgViewHolderModifyTime extends MsgViewHolderBase {

    private String userUrl;
    private int dsmId;
    private String title;

    private TextView tvTitle;

    public MsgViewHolderModifyTime(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        if (isReceivedMessage()) {
            return R.layout.im_ui_message_modify_time_rec;
        }
        return R.layout.im_ui_message_modify_time;
    }

    @Override
    protected void inflateContentView() {
        tvTitle = view.findViewById(R.id.tv_title);
    }

    @Override
    protected void bindContentView() {
        MsgAttachment attachment = message.getAttachment();
        if (attachment instanceof CustomAttachModifyTime) {
            userUrl = ((CustomAttachModifyTime) attachment).getUserUrl();
            dsmId = ((CustomAttachModifyTime) attachment).getDsmId();
            title = ((CustomAttachModifyTime) attachment).getTitle();
            tvTitle.setText(title);
        }

        hideItemBg();
    }

    @Override
    protected void onItemClick() {
        NewH5Activity.start(context, new H5Params(userUrl + "&dsmId=" + dsmId, "预约时间修改"));
    }
}
