package com.yidianling.im.session.viewholder;

import android.widget.TextView;

import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachmentOrderStatus;

/**
 * 后台推送到订单状态
 * Created by harvie on 2017/1/13.
 */

public class MsgViewHolderOrderStatus extends MsgViewHolderBase {
    private TextView message_receive_tv;
    private String from_content;
    private String from_uid;
    private String to_uid;
    private String orderid;

    public MsgViewHolderOrderStatus(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_common_tip;
    }
    @Override
    protected void inflateContentView() {
        message_receive_tv=findViewById(R.id.message_receive_tv);
    }

    @Override
    protected void bindContentView() {
        if (message.getAttachment() instanceof CustomAttachmentOrderStatus){
            from_content = ((CustomAttachmentOrderStatus) message.getAttachment()).getFrom_content();
            if (from_content!=null){
                message_receive_tv.setText(from_content);
            }
        }

        hideItemBg();
        hideHead();
    }

    @Override
    protected void onItemClick() {

    }
}
