package com.yidianling.im.session.viewholder;

import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.widget.TextView;

import com.ydl.ydlcommon.base.config.HttpConfig;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.im.R;
import com.yidianling.im.session.extension.CustomAttachmentReceivedSuccess;
import com.yidianling.im.session.extension.CustomAttachmentReceivedTimeout;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;

/**
 * 后台推送到收款状态，比如超时未支付或者已经支付到拓展
 * Created by harvie on 2017/1/13.
 */

public class MsgViewHolderReceivedStatus extends MsgViewHolderBase {
    private TextView message_receive_tv;
    private String from_content;
    private String from_uid;
    private String touid;
    private String orderid;

    public MsgViewHolderReceivedStatus(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_received_status;
    }
    @Override
    protected void inflateContentView() {
        message_receive_tv=findViewById(R.id.message_receive_tv);
    }

    @Override
    protected void bindContentView() {
        if (message.getAttachment() instanceof CustomAttachmentReceivedSuccess){
            CustomAttachmentReceivedSuccess customAttachmentRedStatus= (CustomAttachmentReceivedSuccess) message.getAttachment();
            orderid=customAttachmentRedStatus.getOrderid();
            from_content=customAttachmentRedStatus.getFrom_content();
            int redIndex=from_content.indexOf("收款");
            SpannableStringBuilder  ssb=new SpannableStringBuilder(from_content);
            ForegroundColorSpan fcs=new ForegroundColorSpan(0xFF3e82f7);
            ssb.setSpan(fcs,redIndex,redIndex+2, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            message_receive_tv.setText(
                    ssb
            );
        }else if (message.getAttachment() instanceof CustomAttachmentReceivedTimeout){
            CustomAttachmentReceivedTimeout customAttachmentReceivedTimeout= (CustomAttachmentReceivedTimeout) message.getAttachment();
            orderid=customAttachmentReceivedTimeout.getOrderid();
            from_content=customAttachmentReceivedTimeout.getFrom_content();
            int redIndex=from_content.indexOf("收款");
            SpannableStringBuilder  ssb=new SpannableStringBuilder(from_content);
            ForegroundColorSpan fcs=new ForegroundColorSpan(0xFF3e82f7);
            ssb.setSpan(fcs,redIndex,redIndex+2, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            message_receive_tv.setText(
                    ssb
            );
        }

        hideItemBg();
        hideHead();
    }

    @Override
    protected void onItemClick() {

        NewH5Activity.start(view.getContext(),new H5Params(HttpConfig.Companion.getH5_URL()+"receipt/order?oid="+orderid,null));
    }
}
