package com.yidianling.im.ui.activity;

import android.view.View;
import android.widget.ListView;

import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.data.http.ThrowableConsumer;
import com.ydl.ydlcommon.utils.remind.ToastHelper;
import com.ydl.ydlcommon.view.TitleBar;
import com.yidianling.im.R;
import com.yidianling.im.bean.SystemMsgBean;
import com.yidianling.im.http.ImHttp;
import com.yidianling.im.http.ImHttpImpl;
import com.yidianling.im.message.param.MsgListParam;
import com.yidianling.im.ui.adapter.SystemMsgAdapter;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import in.srain.cube.views.ptr.PtrDefaultHandler;
import in.srain.cube.views.ptr.PtrFrameLayout;
import in.srain.cube.views.ptr.PtrHandler;
import in.srain.cube.views.ptr.header.MaterialHeader;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;

/**
 * 系统消息列表
 */
public class SystemMsgDetailActivity extends BaseActivity implements PtrHandler{

    PtrFrameLayout store_house_ptr_frame;
    ListView lv_content;
    View ll_empty;
    TitleBar titlebar;

    int type;  //消息类别

    String title;

    int page = 0;

    SystemMsgAdapter adapter;

    @Override
    protected int layoutResId() {
        return R.layout.im_activity_system_msg_detail;
    }

    @Override
    protected void initDataAndEvent() {
        store_house_ptr_frame = findViewById(R.id.store_house_ptr_frame);
        lv_content = findViewById(R.id.lv_content);
        ll_empty = findViewById(R.id.ll_empty);
        titlebar = findViewById(R.id.title_bar);
        type = getIntent().getIntExtra("type", 0);
        title = getIntent().getStringExtra("title");
        init();
    }

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }

    void init() {
        titlebar.setTitle(title);
        // header
        final MaterialHeader header = new MaterialHeader(this);
        int[] colors = getResources().getIntArray(R.array.ydl_colors);
        header.setColorSchemeColors(colors);
        header.setLayoutParams(new PtrFrameLayout.LayoutParams(-1, -2));
        int padding = (int) this.getResources().getDimension(R.dimen.im_default_dis_size);
        header.setPadding(0, padding, 0, padding);
        header.setPtrFrameLayout(store_house_ptr_frame);
        store_house_ptr_frame.setHeaderView(header);
        store_house_ptr_frame.setPtrHandler(this);
        store_house_ptr_frame.addPtrUIHandler(header);

        adapter = new SystemMsgAdapter(this);

        lv_content.setAdapter(adapter);
        lv_content.setEmptyView(ll_empty);

        getMsgData(false);
    }

    private void getMsgData(final boolean loadMore) {
        if (loadMore) {
            page++;
        } else {
            page = 1;
        }

        ImHttp httpHelper = ImHttpImpl.Companion.getInstance();
        Disposable disposable = httpHelper.getSysMsgList(new MsgListParam(page + "", type))
                .compose(RxUtils.applySchedulers(this))
                .compose(RxUtils.resultData())
                .subscribe(systemMsgBeans -> {
                    store_house_ptr_frame.refreshComplete();
                    if (systemMsgBeans.isEmpty()) {
                        return;
                    }
                    List<SystemMsgBean> newTemps = new ArrayList();
                    newTemps.addAll(systemMsgBeans);
                    newTemps.addAll(adapter.getDataList());
                    adapter.update(newTemps);
                    if (!loadMore) {
                        Disposable dis = Observable.timer(300, TimeUnit.MILLISECONDS)
                                .observeOn(AndroidSchedulers.mainThread())
                                .subscribe(aLong -> {
                                    //滚动到底部
                                    lv_content.smoothScrollToPosition(adapter.getCount() - 1);
                                });
                    }
                }, new ThrowableConsumer() {
                    @Override
                    public void accept(@NotNull String msg) {
                        store_house_ptr_frame.refreshComplete();
                        ToastHelper.Companion.show(msg);
                    }
                });


    }


    @Override
    public boolean checkCanDoRefresh(PtrFrameLayout frame, View content, View header) {
        return PtrDefaultHandler.checkContentCanBePulledDown(frame, lv_content, header);
    }

    @Override
    public void onRefreshBegin(PtrFrameLayout frame) {
        getMsgData(true);
    }

}
