package com.yidianling.im.ui.adapter;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;

import com.alibaba.android.arouter.launcher.ARouter;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.ydl.ydlcommon.adapter.CommonAdapter;
import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.base.lifecycle.ILifecycleable;
import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.data.http.ThrowableConsumer;
import com.ydl.ydlcommon.utils.StringUtils;
import com.ydl.ydlcommon.utils.remind.ToastHelper;
import com.yidianling.im.bean.MsgData;
import com.yidianling.im.config.constants.ImConstants;
import com.yidianling.im.event.UpdateTabUnreadNumEvent;
import com.yidianling.im.http.ImHttp;
import com.yidianling.im.http.ImHttpImpl;
import com.yidianling.im.message.param.MsgDetailParam;
import com.yidianling.im.router.ImIn;
import com.yidianling.im.ui.view.MsgListItemView;

import org.jetbrains.annotations.NotNull;

import java.util.Map;

import de.greenrobot.event.EventBus;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

/**
 * 消息adapter
 * Created by softrice on 15/12/10.
 */
public class MsgListAdapter extends CommonAdapter<MsgData> {
    private ILifecycleable lifecycleable;
    private Activity context;
    /*** 消息类型*/
    private int type = 0;

    public MsgListAdapter(Activity context) {
        this.context = context;
    }

    private ImHttp httpHelper;

    public MsgListAdapter(Activity context, int type, ILifecycleable lifecycleable) {
        this.context = context;
        this.type = type;
        this.lifecycleable = lifecycleable;
        httpHelper = ImHttpImpl.Companion.getInstance();
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {

        if (convertView == null) {
            convertView = new MsgListItemView(context, type);
        }
        ((MsgListItemView) convertView).setData(mDataList.get(position));
        convertView.setOnClickListener(v -> {
            //动态消息暂时不需要访问以下接口
            boolean fla = false;
            //判断是否是跳转专家主页
            boolean boo = jumpForUrl(mDataList.get(position).link);

            if (!boo) {
                //事件未消费
                switch (mDataList.get(position).type) {
                    case 1108:
                    case 1111:
                        context.startActivity(ImIn.INSTANCE.membersIntent(context, mDataList.get(position).relation_id));
                        fla = true;
                        break;
                    case 1109://跳转到回复详情
                    case 1113:// 跳转到回复详情(有回复动态)

                        MsgData msgData = mDataList.get(position);
                        context.startActivity(ImIn.INSTANCE.replayInfoIntent(context, msgData.relation_id, msgData.relation_id2));
                        fla = true;
                        break;

                    case 1110:
                        context.startActivity(ImIn.INSTANCE.trendsDetailIntent(context, Integer.valueOf(mDataList.get(position).relation_id), true));
                        fla = true;
                        break;
                    case 1112:

                        String lastid = mDataList.get(position).relation_id2;

                        int trendId = Integer.valueOf(mDataList.get(position).relation_id.trim());
                        int lastId = TextUtils.isEmpty(lastid) ? 0 : Integer.valueOf(lastid.trim());
                        context.startActivity(ImIn.INSTANCE.trendsDetailIntent(context, trendId, true, lastId));
                        fla = true;
                        break;
                    case 600: //跳转H5页面--课程详情
                    case 1116://课程评论回复
                        H5Params h5Params = new H5Params(mDataList.get(position).link, null);
                        h5Params.setShareData(mDataList.get(position).share);
                        NewH5Activity.start(context, h5Params);
                        break;
                    case 1400://投诉反馈
                        ARouter.getInstance().build("/mine/MyFeedBackActivity").withString("intent_id", mDataList.get(position).relation_id).navigation();
                        fla = true;
                        break;
                    default:
                        break;
                }
            }

            if (fla || boo) {
                //跟新未读
                Disposable dis = httpHelper.getMsgDetail(new MsgDetailParam(mDataList.get(position).id))
//                        .compose(RxUtils.applySchedulers(lifecycleable))
                        .subscribeOn(Schedulers.io())
                        .compose(RxUtils.resultData())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(msgDetail -> {
                            mDataList.get(position).is_read = 2;
                            notifyDataSetChanged();
                            EventBus.getDefault().post(new UpdateTabUnreadNumEvent());
                        }, new ThrowableConsumer() {
                            @Override
                            public void accept(@NotNull String msg) {
                                ToastHelper.Companion.show(msg);
                            }
                        });
                //如果是动态消息则到此结束，其它消息类型走下面流程
            } else {
                Disposable di = httpHelper.getMsgDetail(new MsgDetailParam(mDataList.get(position).id))
//                        .compose(RxUtils.applySchedulers(lifecycleable))
                        .subscribeOn(Schedulers.io())
                        .compose(RxUtils.resultData())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(msgDetail -> {
                            mDataList.get(position).is_read = 2;
                            notifyDataSetChanged();
                            EventBus.getDefault().post(new UpdateTabUnreadNumEvent());
                            switch (msgDetail.type) {
                                case 1:
                                case 2:
                                case 501:
                                case 502:
                                case 506:
                                    //预约详情
                                    H5Params h5Params = new H5Params(ImIn.INSTANCE.getReserveHost() + msgDetail.relation_id1, null);
                                    NewH5Activity.start(context, h5Params);
                                    break;
                                case 504:
                                case 505:
                                    //微问诊列表
                                    H5Params h5Paramswe = new H5Params(ImConstants.Companion.getMY_CHAT(), null);
                                    NewH5Activity.start(context, h5Paramswe);
                                    break;
                                case 507:
                                case 508:
                                case 509:
                                    //预约评价  微问诊评价  倾诉评价
                                    H5Params h5Paramspi = new H5Params(ImConstants.Companion.getYYPJ() + msgDetail.relation_id1, null);
                                    NewH5Activity.start(context, h5Paramspi);
                                    break;
                                case 510:
                                    //免费体验详情
                                    H5Params h5Paramsmi = new H5Params(ImConstants.Companion.getFREEDTAIL() + msgDetail.relation_id1, null);
                                    NewH5Activity.start(context, h5Paramsmi);
                                    break;
                                case 503:
                                case 1001:
                                case 1002:
                                case 1004://老板心事心事详情
                                    break;

                                case 1003:
                                    ImIn.INSTANCE.myRedPockIntent(context);
                                    break;

                                case 521:
                                case 522:
                                case 523:
                                case 524://评价提醒
                                case 525:
                                case 526:
                                case 527://付款成功5分钟未选择时间
                                case 528://服务单咨询时间到期前1小时提醒
                                case 540://订单退款成功
                                    // 521-526 解忧 - 订单详情
                                    H5Params orderParams = new H5Params(
                                            ImConstants.Companion.getORDER_DETAIL()
                                                    + (msgDetail.relation_id1.isEmpty() ? "" : msgDetail.relation_id1),
                                            null);
                                    NewH5Activity.start(context, orderParams);
                                    break;
                                default:
                                    break;
                            }
                        }, new ThrowableConsumer() {
                            @Override
                            public void accept(@NotNull String msg) {
                                ((BaseActivity) context).dismissProgressDialog();
                                ToastHelper.Companion.show(msg);
                            }
                        });

            }

        });
        return convertView;
    }

    public void updataAll() {
        for (MsgData bean : mDataList) {
            bean.is_read = 2;
        }
        notifyDataSetChanged();
    }

    /**
     * 根据url解析跳转
     */
    private boolean jumpForUrl(String url) {
        boolean fa = false;
        Map<String, String> map = StringUtils.IsHttpReturn(url);
        String jump_type = map.get("jump_type");

        if ("url".equals(jump_type)) {
            String real_url = map.get("url");
            String url_page = map.get("url_page");
            if ("experts".equals(url_page)) {

                H5Params h5Paramsj = new H5Params(real_url, null);
                NewH5Activity.start(context, h5Paramsj);
                fa = true;
            }
        }
        return fa;
    }
}
