package com.yidianling.im.ui.page.fragment.adapter

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.ViewGroup
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.utils.StringUtils
import com.yidianling.im.api.bean.MsgDetail
import com.yidianling.im.config.constants.ImConstants
import com.yidianling.im.http.ImHttpImpl
import com.yidianling.im.message.param.MsgDetailParam
import com.yidianling.im.router.ImIn
import com.yidianling.im.ui.page.fragment.bean.InteractItemBean
import com.yidianling.im.ui.page.fragment.view.InteractFooterItemView
import com.yidianling.im.ui.page.fragment.view.InteractItemView
import com.yidianling.im.ui.page.fragment.view.InteractTimeItemView
import io.reactivex.android.schedulers.AndroidSchedulers

/**
 * 互动列表适配器
 * Created by xj on 2019/10/14.
 */
class InteractAdapter(var context: Context, private var mList: ArrayList<InteractItemBean>) :
    RecyclerView.Adapter<RecyclerView.ViewHolder>() {


    companion object {
        const val TYPE_NORMAL_ITEM = 1001 // 正常item
        const val TYPE_NORMAL_TIME_ITEM = 1002 // 有时间的item
    }

    override fun getItemViewType(position: Int): Int {
        if (mList[position].createTimeStr != "") return TYPE_NORMAL_TIME_ITEM
        return TYPE_NORMAL_ITEM
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder) {
            is InteractItemHolder -> {
                holder.view.initData(mList[position])
                holder.view.setOnClickListener {
                    initClick(mList[position], position)
                }
            }
            is InteractTimeItemHolder -> {
                holder.view.initData(mList[position])
                holder.view.setOnClickListener {
                    initClick(mList[position], position)
                }
            }
            else -> {
            }
        }
    }

    /**
     * 点击的时候先调接口，将数据库数据更新为已读，接口调用成功之后，刷新本地数据并跳转
     */
    @SuppressLint("CheckResult")
    private fun initClick(bean: InteractItemBean, index: Int) {

        ImHttpImpl.getInstance().getMsgDetail(MsgDetailParam(bean.id.toString()))
            .compose(RxUtils.resultData<MsgDetail>())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe({ res ->
            }, { t ->
            })

        //这里直接进行跳转，不然等待接口调用成功再跳转，会有点慢
        mList[index].isRead = 2

        notifyItemChanged(index + 1)


        // 解析url，看是否跳转
        if (!jumpForUrl(bean.link)) {

            when (bean.type) {
                503 -> {
                } //普通用户收到感谢
                505 -> { //微问诊被回复
                    val h5Paramswe = H5Params(ImConstants.MY_CHAT, null)
                    NewH5Activity.start(context, h5Paramswe)
                }
                1001 -> {
                } //心事被回答
                1002 -> {
                } //心事被回复
                1003 -> { //首次说心事-送2元红包
                    ImIn.myRedPockIntent(context as Activity)
                }
                1004 -> {
                } //心事收到温暖
                1100 -> {
                } //主帖被回复
                1101 -> {
                } //主帖被点赞
                1102 -> {
                } //主帖被置顶
                1103 -> {
                } //主帖被删除
                1104 -> {
                } //回帖被回复
                1105 -> {
                } //回帖被点赞
                1106 -> {
                } //回帖被删除
                1107 -> {
                } //讨论邀请
                1108 -> { //1108 动态个人主页被点赞  1111 关注用户
                    context.startActivity(ImIn.membersIntent(context as Activity, bean.relationId1))
                }
                1111 -> { //1108 动态个人主页被点赞  1111 关注用户
                    context.startActivity(ImIn.membersIntent(context as Activity, bean.relationId1))
                }
                1109 -> { //1109 动态回复被点赞 1113 动态的评论被回复
                    context.startActivity(
                        ImIn.replayInfoIntent(
                            context as Activity,
                            bean.relationId1,
                            bean.remark
                        )
                    )
                }
                1113 -> { //1109 动态回复被点赞 1113 动态的评论被回复
                    context.startActivity(
                        ImIn.replayInfoIntent(
                            context as Activity,
                            bean.relationId1,
                            bean.remark
                        )
                    )
                }
                1110 -> { // 温暖  ->  评论详情
                    context.startActivity(
                        ImIn.trendsDetailIntent(
                            context as Activity,
                            Integer.valueOf(bean.relationId1)!!,
                            true
                        )
                    )
                }
                1112 -> { // 收到评论  ->  评论详情
                    context.startActivity(
                        ImIn.trendsDetailIntent(
                            context as Activity,
                            Integer.valueOf(bean.relationId1)!!,
                            false
                        )
                    )
                }
                1114 -> { // 访客  -> 专家首页
                    context.startActivity(
                        ImIn.membersIntent(
                            context as Activity,
                            bean.relationUid.toString()
                        )
                    )
                }
                1115 -> {
                } //专家主页被访问
                else -> {
                }
            }
        }


    }

    //根据url解析跳转
    private fun jumpForUrl(url: String): Boolean {
        val map = StringUtils.IsHttpReturn(url)
        val jumpType = map["jump_type"]

        if ("url" == jumpType) {
            val realUrl: String? = map["url"]
            val urlPage = map["url_page"]
            if ("experts" == urlPage) {
                realUrl?.let {
                    val h5Param = H5Params(realUrl, null)
                    NewH5Activity.start(context, h5Param)
                    return true
                }
            }
        }
        return false
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            TYPE_NORMAL_ITEM -> {
                InteractItemHolder(InteractItemView(context))
            }
            TYPE_NORMAL_TIME_ITEM -> {
                InteractTimeItemHolder(InteractTimeItemView(context))
            }
            else -> {
                InteractFooterItemHolder(InteractFooterItemView(context))
            }
        }

    }

    override fun getItemCount(): Int {
        return mList.size
    }

    /**
     * 互动列表正常item的holder
     */
    inner class InteractItemHolder(val view: InteractItemView) : RecyclerView.ViewHolder(view)

    /**
     * 互动列表有时间的item的holder
     */
    inner class InteractTimeItemHolder(val view: InteractTimeItemView) :
        RecyclerView.ViewHolder(view)

    /**
     * 互动列表底部item的holder
     */
    inner class InteractFooterItemHolder(val view: InteractFooterItemView) :
        RecyclerView.ViewHolder(view)

}



