package com.yidianling.im.ui.page.fragment.adapter

import android.content.Context
import android.content.Intent
import androidx.recyclerview.widget.RecyclerView
import android.view.ViewGroup
import com.yidianling.im.ui.activity.OtherMsgDetailActivity
import com.yidianling.im.ui.activity.SystemMsgDetailActivity
import com.yidianling.im.ui.page.fragment.bean.NoticeItemBean
import com.yidianling.im.ui.page.fragment.view.NoticeFooterItemView
import com.yidianling.im.ui.page.fragment.view.NoticeItemView
import com.yidianling.im.event.ReQureyUnreadNum
import de.greenrobot.event.EventBus

/**
 * 互动列表适配器
 * Created by xj on 2019/10/14.
 */
class NoticeAdapter(var context: Context, private var mList: ArrayList<NoticeItemBean>) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {


    companion object {
        // 正常item
        const val TYPE_NORMAL_ITEM = 1001
    }

    override fun getItemViewType(position: Int): Int {
        return TYPE_NORMAL_ITEM
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder) {
            is NoticeItemHolder -> {
                holder.view.initData(mList[position])
                holder.view.setOnClickListener {
                    EventBus.getDefault().post(ReQureyUnreadNum())
                    when (mList[position].mType) {
                        1 -> { // 优惠券红包发放提醒 || 壹点零消息推送
                            val intent1 = Intent(context, SystemMsgDetailActivity::class.java)
                            intent1.putExtra("title", mList[position].title)
                            intent1.putExtra("type", Integer.parseInt(mList[position].mType.toString()))
                            intent1.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                            context.startActivity(intent1)
                        }
                        else -> {
                            val intent1 = Intent(context, OtherMsgDetailActivity::class.java)
                            intent1.putExtra("title", mList[position].title)
                            intent1.putExtra("type", Integer.parseInt(mList[position].mType.toString()))
                            intent1.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                            context.startActivity(intent1)
                        }
                    }
                }

            }
            else -> {
            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            TYPE_NORMAL_ITEM -> {
                NoticeItemHolder(NoticeItemView(context))
            }
            else -> {
                NoticeFooterItemHolder(NoticeFooterItemView(context))
            }
        }

    }

    override fun getItemCount(): Int {
        return mList.size
    }

    /**
     * 互动列表正常item的holder
     */
    inner class NoticeItemHolder(val view: NoticeItemView) : RecyclerView.ViewHolder(view)

    /**
     * 互动列表底部item的holder
     */
    inner class NoticeFooterItemHolder(val view: NoticeFooterItemView) : RecyclerView.ViewHolder(view)

}