package com.yidianling.im.ui.view;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydlcommon.adapter.BaseRecyclerAdapter;
import com.ydl.ydlcommon.bean.ShareData;
import com.ydl.ydlcommon.view.BaseViewHolder;
import com.ydl.ydlcommon.view.JumpTextView;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.im.R;
import com.yidianling.im.bean.SystemMsgBean;
import com.yidianling.im.router.ImIn;

import java.util.ArrayList;
import java.util.List;

import jp.wasabeef.glide.transformations.RoundedCornersTransformation;

/**
 * 站内信--系统通知
 * Created by jinkai on 16/5/13.
 */
public class SystemItemView extends LinearLayout {

    //    @BindView(R.id.banner)
    ImageView banner;
    //    @BindView(R.id.content)
    TextView content;
    //    @BindView(R.id.recycler_list)
    RecyclerView recycler_list;
    //    //列表适配器
    private BaseRecyclerAdapter<SystemMsgBean.SystemMBean> adapter;
    //    @BindView(R.id.time)
    TextView time;
    //    @BindView(R.id.rela_body)
    RelativeLayout rela_body;

    Context context;
    private JumpTextView jump_detail;
    private LinearLayout layoutTitle;

    public SystemItemView(Context context) {
        super(context);
        this.context = context;
        inflate(context, R.layout.im_ui_system_msg_item, this);
        banner = findViewById(R.id.banner);
        content = findViewById(R.id.content);
        recycler_list = findViewById(R.id.recycler_list);
        time = findViewById(R.id.time);
        rela_body = findViewById(R.id.rela_body);
        jump_detail = findViewById(R.id.jump_detail);
    }

    private void init(RecyclerView recycler_list) {
        recycler_list.setLayoutManager(new LinearLayoutManager(context));
        adapter = new BaseRecyclerAdapter<SystemMsgBean.SystemMBean>(context, new ArrayList<SystemMsgBean.SystemMBean>(), R.layout.im_ui_system_msg_item_list) {
            @Override
            protected void convert(Context mContext, BaseViewHolder holder, final SystemMsgBean.SystemMBean o, int position) {
                //第一个item作为大图显示，此处仅显示小图item
                if (position == 0) {
                    holder.setVisible(R.id.lin_body, false);
                    return;
                }
                try {
                    holder.setText(R.id.text_content, o.getContent());
                    ImageView img = holder.getView(R.id.img);
                    GlideApp.with(mContext).load(o.getImage_url()).into(img);

                    holder.setOnClickListener(R.id.lin_body, new OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            ShareData shareData = o.getShare();
                            if (shareData == null) {
                                ToastUtil.toastShort("分线数据为空");
                                return;
                            }
                            jump(o.getLink(), o.getShare());
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        recycler_list.setAdapter(adapter);
    }

    public void setData(final SystemMsgBean msgData) {
        try {
            if (!TextUtils.isEmpty(msgData.getItems().get(0).getImage_url())) {
                GlideApp.with(getContext())
                        .load(msgData.getItems().get(0).getImage_url())
                        .transform(new RoundedCornersTransformation(10, 0, RoundedCornersTransformation.CornerType.TOP))
                        .into(banner);

            }
            content.setText(msgData.getItems().get(0).getContent());
            time.setText(msgData.getPost_time());

            rela_body.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    List<SystemMsgBean.SystemMBean> items = msgData.getItems();
                    if (items == null || items.isEmpty()) {
                        ToastUtil.toastShort("分享数据为空");
                        return;
                    }
                    SystemMsgBean.SystemMBean bean = items.get(0);
                    if (bean == null) {
                        ToastUtil.toastShort("分享数据为空");
                        return;
                    }
                    String link = bean.getLink();
                    ShareData share = bean.getShare();
                    jump(link, share);
                }
            });

            if (msgData.getItems().size() > 1) {
                recycler_list.setVisibility(View.VISIBLE);
                content.setVisibility(VISIBLE);
                jump_detail.setVisibility(GONE);
                if (adapter == null) {
                    init(recycler_list);
                }
                adapter.updateData(msgData.getItems());
                if (layoutTitle != null) {
                    layoutTitle.setVisibility(INVISIBLE);
                }
            } else {
                recycler_list.setVisibility(View.GONE);
                content.setVisibility(GONE);
                jump_detail.setVisibility(VISIBLE);
                LogUtil.d("inflate title");
                layoutTitle = findViewById(R.id.ll_title);
                layoutTitle.setVisibility(VISIBLE);
                TextView tvTitle = findViewById(R.id.tv_title);
                tvTitle.setText(msgData.getItems().get(0).getContent());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    //url跳转
    private void jump(String jump_url, ShareData share) {
        if (TextUtils.isEmpty(jump_url)){
            return;
        }

        if (jump_url.startsWith("http")) {
            //跳转h5
            H5Params h5Params = new H5Params(jump_url, null);
            if (null != share && !TextUtils.isEmpty(share.getShare_url())) {
                h5Params.setShareData(share);
            }
            NewH5Activity.start(context, h5Params);
        } else {
            Uri uri = Uri.parse(jump_url);
            if (null == uri || TextUtils.isEmpty(uri.getScheme())) {
                return;
            }
            if (uri.getScheme().equals("ydl") || uri.getScheme().equals("ydl-user")) {
                String id = uri.getQueryParameter("id");
                if (TextUtils.isEmpty(uri.getHost())) {
                    return;
                }
                switch (uri.getHost()) {
                    case "topic":
                        if (!TextUtils.isEmpty(id)) {
                            ImIn.INSTANCE.topicDetailActivity((Activity)context, id);
                        }
                        break;
                    case "active":
                        if (!TextUtils.isEmpty(id)) {
                            context.startActivity(ImIn.INSTANCE.trendsDetailIntent((Activity) context, Integer.valueOf(id)));
                        }
                        break;
                    case "course":
                        if ("/special".equals(uri.getPath())) {
                            //课程专题页面
                            if (TextUtils.isEmpty(id)) {
                                return;
                            }
                            String courseId = id;
                            ImIn.INSTANCE.courseTopic((Activity) context, courseId);
                        } else {
                            ImIn.INSTANCE.mainIntent(context, 2);
                        }
                        break;
                    case "fm":
                        if (!TextUtils.isEmpty(id)) {
                            int fm_idi = Integer.valueOf(id);
                            context.startActivity(ImIn.INSTANCE.fmDetailIntent((Activity) context, fm_idi));
                        }
                        break;
                    case "confide":
                        //倾诉
                        if("/home".equals(uri.getPath())){
                            //倾诉首页
                            ImIn.INSTANCE.getConfideService().openConfideHome(context);
                        }
                        break;
                }
            }
        }
    }
}
