package com.yidianling.uikit.business.session.view.question;

import android.graphics.Color;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ydl.ydl_image.module.GlideApp;
import com.yidianling.avchatkit.AVChatKit;
import com.yidianling.im.R;
import com.yidianling.im.router.ImIn;
import com.yidianling.uikit.custom.http.response.question.OptionsBean;

import java.util.ArrayList;
import java.util.List;

/**
 * @author liupeng
 */
public class QuestionAdapter extends BaseMultiItemQuickAdapter<QuestionMultiItem, BaseViewHolder> {
    /**
     * 文字最大数量，大于6个展示单列，小于六个展示双列
     */
    private int mTextMaxSize = 6;
    private QuestionOneCheckListener mOneCheckListener;

    public QuestionAdapter(List<QuestionMultiItem> data) {
        super(data);
        //左----文字
        addItemType(1, R.layout.item_left_text_layout);
        //右----文字
        addItemType(2, R.layout.item_right_text_layout);
        //左----单选
        addItemType(3, R.layout.item_left_one_check_layout);
        //左----多选
        addItemType(4, R.layout.item_left_more_check_layout);
        //左----描述题
        addItemType(5, R.layout.item_left_describe_layout);
        //主诉----单选
        addItemType(6, R.layout.item_left_one_check_layout);
    }


    @Override
    protected void convert(BaseViewHolder helper, QuestionMultiItem item) {
        switch (helper.getItemViewType()) {
            case 1:
                //左文字
                helper.setText(R.id.tv_left_text, item.type1Text);
                break;
            case 2:
                //右侧文字
                helper.setText(R.id.tv_right_text, item.type2Text);
                ImageView iv_header = helper.getView(R.id.iv_header);
                String header = ImIn.INSTANCE.getUserInfo().getHead();
                if (header != null) {
                    GlideApp.with(mContext)
                            .load(header)
                            .dontAnimate()
                            .placeholder(R.drawable.platform_head_place_hold_pic)
                            .error(R.drawable.platform_head_place_hold_pic)
                            .into(iv_header);
                }
                break;
            case 3:
                //单选
                convertType3(helper, item);
                break;
            case 4:
                //多选
                convertType4(helper, item);
                break;
            case 5:
                convertType5(helper, item);
                break;
            case 6:
                convertType6(helper, item);
                break;
            default:
                break;
        }
    }
    /**
     * 主诉消息
     * */
    private void convertType6(BaseViewHolder helper, QuestionMultiItem item) {
        RecyclerView OneRecycle = helper.getView(R.id.tv_one_list);
        TextView oneTitle = helper.getView(R.id.multiple_choice_title);
        oneTitle.setText(item.questionsBean.name);
        int oneMaxSize = 0;
        for (OptionsBean option : item.questionsBean.options) {
            int length = option.name.length();
            if (length > mTextMaxSize) {
                oneMaxSize = length;
                break;
            } else if (oneMaxSize < length) {
                oneMaxSize = option.name.length();
            }
        }
        GridLayoutManager gridLayoutManager = new GridLayoutManager(AVChatKit.getContext(), oneMaxSize > mTextMaxSize ? 1 : 2);
        OneRecycle.setLayoutManager(gridLayoutManager);
        QuestionOneCheckAdapter oneCheckAdapter = new QuestionOneCheckAdapter(item.questionsBean.options);
        OneRecycle.setAdapter(oneCheckAdapter);
        oneCheckAdapter.setOnItemClickListener(new OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                List<OptionsBean> data = oneCheckAdapter.getData();
                for (OptionsBean datum : data) {
                    if (datum.check) {
                        //如果已有选项被选择，择不触发后续事件
                        return;
                    }
                }
                oneCheckAdapter.getData().get(position).check = true;
                oneCheckAdapter.notifyDataSetChanged();
                mOneCheckListener.zsItemClick(data.get(position).name, item.type6Position);
            }
        });
    }

    private void convertType5(BaseViewHolder helper, QuestionMultiItem item) {
        helper.setText(R.id.multiple_choice_title, item.type5Bean.question);
        helper.setText(R.id.example, item.type5Bean.example);
        SpannableString spannableString = new SpannableString(mContext.getResources().getString(R.string.question_notes));
        spannableString.setSpan(new ForegroundColorSpan(Color.parseColor("#1DA1F2")), 28, spannableString.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        helper.setText(R.id.tv_notes, spannableString);

        View type5_line = helper.getView(R.id.type5_line);
        TextView example = helper.getView(R.id.example);

        if (example.getVisibility() == View.GONE) {
            type5_line.setVisibility(View.VISIBLE);
            example.setVisibility(View.VISIBLE);
        } else {
            type5_line.setVisibility(View.GONE);
            example.setVisibility(View.GONE);
        }
        if (item.type5Open) {
            type5_line.setVisibility(View.VISIBLE);
            example.setVisibility(View.VISIBLE);
        } else {
            type5_line.setVisibility(View.GONE);
            example.setVisibility(View.GONE);
        }
        if (item.type5CanClick) {
            helper.getView(R.id.type5_parent).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mOneCheckListener.showKeyboard();
                }
            });

            helper.addOnClickListener(R.id.tv_notes);
        }
    }

    /**
     * 多选
     */
    private void convertType4(BaseViewHolder helper, QuestionMultiItem item) {
        RecyclerView moreRecycle = helper.getView(R.id.tv_more_list);
        TextView tv_more_define = helper.getView(R.id.tv_more_define);
        TextView moreTitle = helper.getView(R.id.more_title);
        moreTitle.setText(item.questionsBean.name);
        int moreMaxSize = 0;
        for (OptionsBean option : item.questionsBean.options) {
            int length = option.name.length();
            if (length > mTextMaxSize) {
                moreMaxSize = length;
                break;
            } else if (moreMaxSize < length) {
                moreMaxSize = option.name.length();
            }
        }
        GridLayoutManager moreLayoutManager = new GridLayoutManager(AVChatKit.getContext(), moreMaxSize > mTextMaxSize ? 1 : 2);
        moreRecycle.setLayoutManager(moreLayoutManager);
        QuestionOneCheckAdapter moreCheckAdapter = new QuestionOneCheckAdapter(item.questionsBean.options);
        moreRecycle.setAdapter(moreCheckAdapter);

        if (getCheckOptionsBeans(moreCheckAdapter).size() > 0) {
            tv_more_define.setBackground(ContextCompat.getDrawable(mContext, item.type4CanClick ? R.drawable.im_background_18dp_1da1f2 : R.drawable.im_background_18dp_ebebeb));
            tv_more_define.setEnabled(item.type4CanClick);
            tv_more_define.setText("确定(" + getCheckOptionsBeans(moreCheckAdapter).size() + ")");
        } else {
            tv_more_define.setBackground(ContextCompat.getDrawable(mContext, R.drawable.im_background_18dp_ebebeb));
            tv_more_define.setEnabled(false);
            tv_more_define.setText("确定");
        }

        moreCheckAdapter.setOnItemClickListener(new OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                if (item.type4CanClick) {
                    OptionsBean optionsBean = moreCheckAdapter.getData().get(position);
                    boolean check = optionsBean.check;
                    if (check) {
                        moreCheckAdapter.getData().get(position).check = false;
                    } else {
                        moreCheckAdapter.getData().get(position).check = true;
                    }
                    moreCheckAdapter.notifyDataSetChanged();
                    if (getCheckOptionsBeans(moreCheckAdapter).size() > 0) {
                        tv_more_define.setBackground(ContextCompat.getDrawable(mContext, R.drawable.im_background_18dp_1da1f2));
                        tv_more_define.setEnabled(true);
                        tv_more_define.setText("确定(" + getCheckOptionsBeans(moreCheckAdapter).size() + ")");
                    } else {
                        tv_more_define.setBackground(ContextCompat.getDrawable(mContext, R.drawable.im_background_18dp_ebebeb));
                        tv_more_define.setEnabled(false);
                        tv_more_define.setText("确定");
                    }

                    if ("其他".equals(optionsBean.name)) {
                        if (moreCheckAdapter.getData().get(position).check) {
                            //选中
                            mOneCheckListener.showOtherEdit(getCheckOptionsBeans(moreCheckAdapter), item.questionsBean);
                        } else {
                            //取消选中
                            mOneCheckListener.hideOtherEdit();
                        }
                        return;
                    }

                    if (getHaveCheck(moreCheckAdapter)) {
                        mOneCheckListener.showOtherEdit(getCheckOptionsBeans(moreCheckAdapter), item.questionsBean);
                    }

                }
            }

        });

        tv_more_define.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (item.type4CanClick) {
                    mOneCheckListener.itemClick(getCheckOptionsBeans(moreCheckAdapter), item.questionsBean);
                }
            }
        });
    }

    //单选
    private void convertType3(BaseViewHolder helper, QuestionMultiItem item) {
        RecyclerView OneRecycle = helper.getView(R.id.tv_one_list);
        TextView oneTitle = helper.getView(R.id.multiple_choice_title);
        oneTitle.setText(item.questionsBean.name);
        int oneMaxSize = 0;
        for (OptionsBean option : item.questionsBean.options) {
            int length = option.name.length();
            if (length > mTextMaxSize) {
                oneMaxSize = length;
                break;
            } else if (oneMaxSize < length) {
                oneMaxSize = option.name.length();
            }
        }
        GridLayoutManager gridLayoutManager = new GridLayoutManager(AVChatKit.getContext(), oneMaxSize > mTextMaxSize ? 1 : 2);
        OneRecycle.setLayoutManager(gridLayoutManager);
        QuestionOneCheckAdapter oneCheckAdapter = new QuestionOneCheckAdapter(item.questionsBean.options);
        OneRecycle.setAdapter(oneCheckAdapter);
        oneCheckAdapter.setOnItemClickListener(new OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                List<OptionsBean> data = oneCheckAdapter.getData();
                for (OptionsBean datum : data) {
                    if (datum.check) {
                        //如果已有选项被选择，择不触发后续事件
                        return;
                    }
                }
                oneCheckAdapter.getData().get(position).check = true;

                if ("其他".equals(data.get(position).name)) {
                    //如果选项是其他，发送其他数据   展示其他输入框
                    mOneCheckListener.showOtherEdit(getCheckOptionsBeans(oneCheckAdapter), item.questionsBean);
                } else {
                    oneCheckAdapter.notifyDataSetChanged();
                    List<OptionsBean> list = new ArrayList();
                    list.add(data.get(position));
                    mOneCheckListener.itemClick(list, item.questionsBean);
                }
            }
        });
    }


    /**
     * 获取选中选项
     */
    private List<OptionsBean> getCheckOptionsBeans(QuestionOneCheckAdapter checkAdapter) {
        List<OptionsBean> data = checkAdapter.getData();
        List<OptionsBean> checkList = new ArrayList();
        for (OptionsBean datum : data) {
            if (datum.check) {
                checkList.add(datum);
            }
        }
        return checkList;
    }

    /**
     * 获取单选按钮其他是否选中
     */
    private boolean getHaveCheck(QuestionOneCheckAdapter checkAdapter) {
        List<OptionsBean> data = checkAdapter.getData();
        for (OptionsBean datum : data) {
            if (datum.check && "其他".equals(datum.name)) {
                return true;
            }
        }
        return false;
    }


    public void setOneCheckListener(QuestionOneCheckListener listener) {
        this.mOneCheckListener = listener;
    }
}
