package com.yidianling.uikit.custom.widget

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.WindowManager
import com.yidianling.im.R
import kotlinx.android.synthetic.main.im_safe_help_remind_dialog_layout.*

/**
 * Created by xj on 2019/8/7.
 */
class SafeHelpRemindDialog(val mContext: Context, val listener: SafeHelpRemindListener): Dialog(mContext, R.style.dialog_default_style) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.im_safe_help_remind_dialog_layout)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.MATCH_PARENT
        window.attributes = params

        safe_help_remind_cancel.setOnClickListener { hide() }

        safe_help_remind_sure.setOnClickListener {
            listener?.sureClick()
        }


    }

    interface SafeHelpRemindListener{
        fun sureClick()
    }

}