package com.yidianling.uikit.custom.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.yidianling.im.R;

/**
 * 头部title bar//支持左边文字，中间文字，右边文字，并且支持中间底部文字
 * Created by Dog on 2015/6/21.
 */
public class TitleBarBottom extends RelativeLayout {
    TextView tv_left_text, tv_center_title, tv_bottom_title, tv_right_text;

    ImageView iv_title_divide, image, rightImage, title_tv_right_btn;

    private View root;

    //非激活时候的图标
    Drawable mLeftStartIcon, mLeftEndIcon, mRightStartIcon, mRightEndIcon;
    //判断三者是否激活
    boolean mIsLeftIconActive = false, mIsTitleIconActive = false, mIsRightIconActive = false, mShowBottomTitle = true;
    //颜色默认系统黑色
    int mTextColor, mTitleBg, mSideTextColor;
    //文字内容
    String mLeftText, mTitle, mMinTitle, mRightText;
    //接口部分
    OnTitleBarTextClick mLeftTextClick, mTitleTextClick, mRightTextClick;

    public TitleBarBottom(Context context) {
        this(context, null);
    }

    public TitleBarBottom(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBarBottom(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        root = inflate(context, R.layout.im_nim_ui_title_bar_bottom, null);
        addView(root, new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        initRoot(attrs, defStyleAttr);
    }

    private void findView() {
        tv_left_text = (TextView) root.findViewById(R.id.tv_left_text);
        tv_center_title = (TextView) root.findViewById(R.id.tv_center_title);
        tv_bottom_title = (TextView) root.findViewById(R.id.tv_bottom_title);
        tv_right_text = (TextView) root.findViewById(R.id.tv_right_text);
        iv_title_divide = (ImageView) root.findViewById(R.id.iv_title_divide);
        image = (ImageView) root.findViewById(R.id.image);
        rightImage = (ImageView) root.findViewById(R.id.iv_right);
        title_tv_right_btn = (ImageView) root.findViewById(R.id.title_tv_right_btn);
        setupView();
    }

    /**
     * 设置标题文本右侧icon
     */
    public void setTitleTextRightIcon(int resId, OnClickListener onClickListener) {
        title_tv_right_btn.setImageResource(resId);
        title_tv_right_btn.setVisibility(View.VISIBLE);
        title_tv_right_btn.setOnClickListener(onClickListener);
    }

    /**
     * 左侧文字点击事件
     */
    public void setOnLeftTextClick(OnTitleBarTextClick leftTextClick) {
        this.mLeftTextClick = leftTextClick;
    }

    /**
     * 中间文字点击事件
     */
    public void setOnTitleTextClick(OnTitleBarTextClick titleTextClick) {
        this.mTitleTextClick = titleTextClick;
    }

    /**
     * 右侧图片点击事件
     */
    public void setOnRightImageClick(OnClickListener onClickListener) {
        rightImage.setOnClickListener(onClickListener);
    }

    /**
     * 设置右边图片图标
     */
    public void setRightImageIco(int resId) {
        rightImage.setImageResource(resId);
    }


    /**
     * 右侧文字点击事件
     */
    public void setOnRightTextClick(OnTitleBarTextClick rightTextClick) {
        this.mRightTextClick = rightTextClick;
    }

    /**
     * 设置左侧字符
     *
     * @param mLeftText 内容
     */
    public void setmLeftText(String mLeftText) {
        this.mLeftText = mLeftText;
        tv_left_text.setText(mLeftText);
    }

    public void setLeftTextVisible(int state) {
        tv_left_text.setVisibility(state);
    }

    public void setDivideVisible(boolean hide) {
        if (hide) {
            iv_title_divide.setVisibility(View.GONE);
        } else {
            iv_title_divide.setVisibility(View.VISIBLE);
        }

    }

    /**
     * 设置头部text
     *
     * @param title 内容
     */
    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.mTitle = title;
        tv_center_title.setText(title);
        if (mMinTitle == null || mMinTitle.equals("")) {
            setmMinTitleVisiable(GONE);
        }
    }
    /**
     * 获得头部的内容
     *
     *
     */
    public String getTitle( ) {
        return tv_center_title.getText().toString();
    }
    /**
     * 设置小标题文字
     */
    public void setMinTitleText(String mMinTitle) {
        this.mMinTitle = mMinTitle;
        if (mMinTitle != null && !mMinTitle.equals("")) {
            tv_bottom_title.setText(mMinTitle);
            tv_bottom_title.setVisibility(VISIBLE);
        }
    }

    /**
     * 设置小标题是否可见
     *
     * @param visiable
     */
    public void setmMinTitleVisiable(int visiable) {
        tv_bottom_title.setVisibility(visiable);
    }

    /**
     * 设置小标题颜色
     *
     * @param color
     */
    public void setMinTitleColor(int color) {
        tv_bottom_title.setTextColor(color);
    }

    /**
     * 设置小标题左边的图标
     */
    public void setMinTitleDrawable(Drawable leftDrawable) {
        tv_bottom_title.setCompoundDrawablesWithIntrinsicBounds(leftDrawable, null, null, null);
    }

    /**
     * 设置右侧文字
     *
     * @param mRightText 内容
     */
    public void setmRightText(String mRightText) {
        this.mRightText = mRightText;
        tv_right_text.setText(mRightText);
    }

    /**
     * 设置右侧字符颜色
     */
    public void setRightTextColor(int color) {
        tv_right_text.setTextColor(color);
    }

    /**
     * 设置左侧字符颜色
     */
    public void setLeftTextColor(int color) {
        tv_left_text.setTextColor(color);
    }

    /**
     * 设置背景色
     *
     * @param color int类型的背景色
     */
    public void setBg(int color) {
        setBackgroundColor(color);
    }

    void initRoot(AttributeSet attrs, int defStyleAttr) {
        final TypedArray a = getContext().obtainStyledAttributes(
                attrs, R.styleable.TitleBarBottom, defStyleAttr, 0);

        mLeftText = a.getString(R.styleable.TitleBarBottom_left_text);
        mLeftStartIcon = a.getDrawable(R.styleable.TitleBarBottom_left_start_icon);
        mLeftEndIcon = a.getDrawable(R.styleable.TitleBarBottom_left_end_icon);

        mTitle = a.getString(R.styleable.TitleBarBottom_title_text);

        mRightText = a.getString(R.styleable.TitleBarBottom_right_text);
        mRightStartIcon = a.getDrawable(R.styleable.TitleBarBottom_right_start_icon);
        mRightEndIcon = a.getDrawable(R.styleable.TitleBarBottom_right_end_icon);

        mTextColor = a.getColor(R.styleable.TitleBarBottom_title_bar_text_color, 0xff000000);
        mSideTextColor = a.getColor(R.styleable.TitleBarBottom_side_text_color, 0xff000000);
        mTitleBg = a.getColor(R.styleable.TitleBarBottom_title_bar_bg, getResources().getColor(R.color.im_theme_title_bar_color));
        mShowBottomTitle = a.getBoolean(R.styleable.TitleBarBottom_show_bottom_title, true);
        a.recycle();
        setGravity(Gravity.CENTER_VERTICAL);
        findView();
    }

    public void setLeftIcon(Drawable left) {
        tv_left_text.setCompoundDrawablesWithIntrinsicBounds(left, null, mLeftEndIcon, null);

    }


    private void setupView() {
        //左侧部分
        tv_left_text.setText(mLeftText);
        tv_left_text.setTextColor(mSideTextColor);
        tv_left_text.setCompoundDrawablesWithIntrinsicBounds(mLeftStartIcon, null, mLeftEndIcon, null);
        //中间部分
        tv_center_title.setText(mTitle);
        tv_center_title.setTextColor(mTextColor);
        //右侧部分
        tv_right_text.setText(mRightText);
        tv_right_text.setTextColor(mSideTextColor);
        tv_right_text.setCompoundDrawablesWithIntrinsicBounds(mRightStartIcon, null, mRightEndIcon, null);
        //下标题
        tv_bottom_title.setVisibility(mShowBottomTitle ? VISIBLE : GONE);

        //背景色

        setBackgroundColor(mTitleBg);
        //设置点击事件
        setupTextClick();

    }

    /**
     * 设置文字点击事件
     */
    void setupTextClick() {
        tv_left_text.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mIsLeftIconActive = !mIsLeftIconActive;
                if (mLeftTextClick != null) {
                    mLeftTextClick.onClick(tv_left_text, mIsLeftIconActive);
                } else {
                    //默认退出activity
                    Context context = getContext();
                    if (context instanceof Activity) {
                        ((Activity) context).finish();
                    }
                }
            }
        });


        tv_center_title.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mIsTitleIconActive = !mIsTitleIconActive;
                if (mTitleTextClick != null) {
                    mTitleTextClick.onClick(tv_center_title, mIsTitleIconActive);
                }
            }
        });

        tv_right_text.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mIsRightIconActive = !mIsRightIconActive;
                if (mRightTextClick != null) {
                    mRightTextClick.onClick(tv_right_text, mIsRightIconActive);
                }
            }
        });
    }

    public interface OnTitleBarTextClick {
        /**
         * title bar文字点击事件
         *
         * @param view     被点击的view
         * @param isActive 是否是激活状态
         */
        void onClick(View view, boolean isActive);
    }

    public void setRightIcon(Drawable rightIcon) {

        mRightStartIcon = rightIcon;
        tv_right_text.setCompoundDrawablesWithIntrinsicBounds(mRightStartIcon, null, mRightEndIcon, null);
    }

    public void setImage(Drawable image_) {
        image.setImageDrawable(image_);
    }

    /**
     * 设置标题右边图标
     * 注：设置右边会导致左边图标被去掉
     */
    public void setTitleRightDraw(Drawable right) {
        tv_center_title.setCompoundDrawablesWithIntrinsicBounds(null, null, right, null);
    }

    /**
     * 设置标题左边图标
     * 注：设置左边会导致右边图标被去掉
     */
    public void setTitleLeftDraw(Drawable leftDraw) {
        tv_center_title.setCompoundDrawablesWithIntrinsicBounds(leftDraw, null, null, null);
    }

    public void setImageVis(int vis) {
        switch (vis) {
            case 0:
                image.setVisibility(GONE);
                break;
            default:
                image.setVisibility(VISIBLE);
        }
    }

    public void setImageListener(OnClickListener listener) {
        image.setOnClickListener(listener);
    }


}
