package com.yidianling.home.http

import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.muse.bean.MuseModuleBean
import io.reactivex.Observable

/**
 * @author jiucheng
 * @描述:首页接口实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/22
 */
class MuseHttp {

    companion object {
        fun getInstance(): MuseHttp {
            return Holder.INSTANCE
        }
    }

    object Holder {
        val INSTANCE = MuseHttp()
    }

    private var museApi: MusePagerApi? = null

    private fun getMusePagerApi(): MusePagerApi {
        if (museApi == null) {
            museApi = YDLHttpUtils.obtainApi(MusePagerApi::class.java)
        }
        return museApi!!
    }

    //壹点冥想
    fun newMuseRequest(): Observable<BaseAPIResponse<MuseModuleBean>> {
        return getMusePagerApi().getMuseData()
    }
}