package com.yidianling.tests.home.http

import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.tests.home.bean.TestHomeDataBean
import com.yidianling.tests.home.param.TestHomeParam
import io.reactivex.Observable

/**
 * @author yuanwai
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/26
 */
class TestHomeHttpImpl private constructor() : ITestHomeHttp {

    companion object {
        fun getInstance(): TestHomeHttpImpl {
            return Holder.INSTANCE
        }

        fun clearTestHomeApi() {
            Holder.INSTANCE.testHomeApi = null
        }
    }

    object Holder {
        val INSTANCE = TestHomeHttpImpl()
    }

    private var testHomeApi: TestHomeApi? = null

    private fun getTestHomeApi(): TestHomeApi {
        if (testHomeApi == null){
            testHomeApi=YDLHttpUtils.obtainApi(TestHomeApi::class.java)
        }
        return  testHomeApi!!
    }

    override fun newHomeRequest(testHomeParam: TestHomeParam): Observable<BaseResponse<List<TestHomeDataBean>>> {
        return RxUtils.mapObservable(testHomeParam)
                .flatMap {
                    getTestHomeApi().newHome(it)
                }
    }

    override fun dailyChange(testHomeParam: TestHomeParam): Observable<BaseResponse<TestHomeDataBean>> {
        return RxUtils.mapObservable(testHomeParam)
                .flatMap {
                    getTestHomeApi().dailySelection(it)
                }
    }

    fun fetchMaxCoupon(){

    }


}