package com.yidianling.tests.home.model

import com.ydl.ydlcommon.data.http.RxUtils
import com.yidianling.tests.home.bean.TestHomeDataBean
import com.yidianling.tests.home.contract.ITestHomeContract
import com.yidianling.tests.home.http.TestHomeDataManager
import com.yidianling.tests.home.param.TestHomeParam
import io.reactivex.Observable

/**
 * @author yuanwai
 * @描述:测评首页数据模型实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/26
 */
class TestHomeModelImpl : ITestHomeContract.Model{

    /**
     * 测评首页
     */
    override fun newHomeRequest() : Observable<List<TestHomeDataBean>> {
        return TestHomeDataManager.getHttp().newHomeRequest(TestHomeParam( 0))
                .compose(RxUtils.resultData())
    }

    /**
     * 每日精选--换一批
     */
    override fun dailyChange() : Observable<TestHomeDataBean>{
        return TestHomeDataManager.getHttp().dailyChange(TestHomeParam( 1))
                .compose(RxUtils.resultData())
    }
}