package com.yidianling.tests.home.plugin

import android.app.Activity
import android.net.Uri
import com.channel.ydl_flutter_base.base.BaseFlutterFragment
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydl_router.manager.YDLRouterManager
import com.ydl.ydl_router.manager.YDLRouterParams
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.tests.home.config.TestBIConstants
import com.yidianling.tests.list.view.TestCategoryListActivity
import com.yidianling.tests.router.TestsIn
import com.yidianling.tests.search.TestSearchActivity
import io.flutter.app.FlutterActivity
import io.flutter.plugin.common.MethodCall
import io.flutter.plugin.common.MethodChannel
import io.flutter.view.FlutterView

/**
 * Created by xj on 2019/11/19.
 */
class TestPlugin : MethodChannel.MethodCallHandler {

    private var mActivity: Activity? = null
    private constructor(activity: Activity) {
        mActivity = activity
    }
    companion object {
        const val CHANNEL: String = "lib/test_module/channel"
        const val GO_BACK = "goBack" // 左上角返回按钮
        const val GO_SEARCH = "goSearch" // 查找测评
        const val GO_MY_TESTS = "goMyTests" // 我的测评
        const val BANNER_CLICK = "bannerClick" // Banner点击
        const val CATEGORY_CLICK = "categoryClick" // 分类点击
        const val ADVERT_CLICK = "advertClick" // 实时测评点击
        const val TEST_LIST_ITEM_CLICK = "testListItemClick" // 测评列表点击
        const val LOOK_ALL_TEST = "lookAllTest" // 查看全部测评
        const val IS_HIDE_LEFT_BACK = "hideLeftBackLL" // 是否隐藏标题左侧布局

        var isHideLeftBack = false // 是否隐藏标题左侧布局


        fun register(activity: FlutterActivity) {
            isHideLeftBack = false
            MethodChannel(activity.flutterView, CHANNEL).setMethodCallHandler(TestPlugin(activity))
        }

        fun register(fragment: BaseFlutterFragment, flutterView: FlutterView) {
            isHideLeftBack = true
            MethodChannel(flutterView, CHANNEL).setMethodCallHandler(TestPlugin(fragment.activity!!))
        }
    }

    override fun onMethodCall(methodCall: MethodCall, result: MethodChannel.Result) {
        when (methodCall.method) {
            GO_BACK -> {
//                ActionCountUtils.count(TestBIConstants.YDL_TEST_MAIN_RETURN_CLICK)
                mActivity?.finish()
            }
            GO_SEARCH -> {
//                ActionCountUtils.count(TestBIConstants.YDL_TEST_MAIN_SEARCH_CLICK)
                mActivity?.let {
                    TestSearchActivity.start(mActivity!!)
                }
            }
            GO_MY_TESTS -> {
                if (!TestsIn.loginByOneKeyLogin(mActivity!!,true)) {
                    //如果未登录 走登录逻辑
                    return
                }
                val testParam = H5Params(HttpConfig.MH5_URL + "ceshi/my-test", "测试记录")
                mActivity?.let {
                    NewH5Activity.start(mActivity, testParam)
                }
            }
            BANNER_CLICK -> {

                var linkUrl: String? = methodCall.argument<String>("linkUrl")
                linkUrl?.let {
                    link(linkUrl)
                }
//                ActionCountUtils.count(TestBIConstants.YDL_TEST_MAIN_BANNER_CLICK,linkUrl?:"")

            }
            CATEGORY_CLICK -> {
                mActivity?.let {
                    var tabName: String = methodCall.argument<String>("tabName")?:""
                    TestCategoryListActivity.start(mActivity!!, tabName)

//                    ActionCountUtils.count(TestBIConstants.YDL_TEST_MAIN_ICON_CLICK,tabName)
                }

            }
            ADVERT_CLICK -> {
//                ActionCountUtils.count(TestBIConstants.YDL_TEST_MAIN_SCROLL_BAR_CLICK)

                var linkUrl: String? = methodCall.argument<String>("linkUrl")
                linkUrl?.let {
                    link(linkUrl)
                }
            }
            TEST_LIST_ITEM_CLICK -> {
                var linkUrl: String? = methodCall.arguments.toString()
//                ActionCountUtils.count(TestBIConstants.YDL_TEST_MAIN_ALL_TEST_LIST_CLICK,linkUrl?:"")

                linkUrl?.let {
                    link(linkUrl)
                }
            }
            LOOK_ALL_TEST -> {
//                ActionCountUtils.count(TestBIConstants.YDL_TEST_MAIN_VIEW_ALL_CLICK)

                mActivity?.let {
                    TestCategoryListActivity.start(mActivity!!)
                }
            }
            IS_HIDE_LEFT_BACK -> {
                result.success(isHideLeftBack)
            }
        }
    }

    private fun link(linkUrl: String?) {
        if (null == linkUrl || linkUrl.isEmpty()) {
            return
        }
        if (linkUrl.startsWith("app")) {
            val uri = Uri.parse(linkUrl)
            if ("ceshi" == uri.host) {
                val id = uri.getQueryParameter("id")
//                YDLRouterManager.router(IYDLRouterConstant.ROUTER_TEST_DETAIL, YDLRouterParams().putExtra(IYDLRouterConstant.EXTRA_ID, id))
                TestsIn.getTestsImpl().testDetailH5(id)
            }
        } else if (linkUrl.startsWith("http")) {
            YDLRouterManager.router(
                    IYDLRouterConstant.ROUTER_H5_H5,
                    YDLRouterParams().putExtra(IYDLRouterConstant.EXTRA_URL, linkUrl), "")
        } else {
            YDLRouterManager.router(linkUrl)
        }
    }

    interface TestPluginDelegate{
        fun getHideBack():Boolean
    }
}