package com.yidianling.tests.home.widget

import android.content.Context
import android.util.TypedValue
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.common.tools.RxImageTool
import com.yidianling.tests.R
import com.yidianling.tests.home.bean.TestHomeBodyBean
import com.yidianling.tests.home.bean.TestHomeCategoryBean
import com.yidianling.tests.home.bean.TestHomeDataBean
import com.yidianling.tests.home.event.ITestHomeEvent
import com.ydl.ydlcommon.utils.ScreenUtil
import kotlinx.android.synthetic.main.tests_testhome_category_view.view.*
import java.util.*

/**
 * @author yuanwai
 * @描述:测评首页测评分类View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/27
 */
class TestHomeCategoryView(mContext: Context, testHomeEvent: ITestHomeEvent) : LinearLayout(mContext) {
    /**
     * 数据缓存
     */
    var mDataList: List<TestHomeCategoryBean>? = null
    /**
     * 分类view宽度
     */
    var categoryWidth: Int = 0
    /**
     * 图片宽高
     */
    var imageViewWidth: Int = 0
    /**
     * 文本宽度
     */
    var textViewWidth: Int = 0
    /**
     * 文本高度
     */
    var textViewHeight: Int = 0
    /**
     * 间隔
     */
    var margin: Int = 0

    var dp8: Int = 0
    /**
     * 是否添加了实时测试状态View
     */
    var hasRealTestView: Boolean = false

    private var realTestView: TestHomeRealTestView? = null
    /**
     * 线
     */
    private var lineView: View? = null
    /**
     * 图片View缓存
     */
    private var imageViewCache: List<ImageView>? = null
    /**
     * 文本View缓存
     */
    private var textViewCache: List<TextView>? = null
    /**
     * 倍数
     */
    private var multiple: Int = 0
    /**
     * 测评首页事件处理类
     */
    private var testHomeEvent: ITestHomeEvent? = null

    init {
        initView()
        this.testHomeEvent = testHomeEvent
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        orientation = VERTICAL
        View.inflate(context, R.layout.tests_testhome_category_view, this)
        val params = ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        initArgs()
    }

    /**
     * 初始化变量
     */
    private fun initArgs() {
        categoryWidth = ScreenUtil.screenWidth - RxImageTool.dp2px(30f)
        textViewWidth = categoryWidth / 4
        imageViewWidth = RxImageTool.dip2px(38f)
        margin = (categoryWidth - 4 * imageViewWidth) / 8
        dp8 = RxImageTool.dip2px(8f)
        //高度=文字12dp+16dp间距
        textViewHeight = RxImageTool.dip2px(28f)
    }

    fun initData(bean: TestHomeDataBean) {
        if (null == bean ||
                (bean.body == null && bean.category == null) ||
                (bean.body!!.isEmpty() && bean.category!!.isEmpty())) {
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        if (null == mDataList) {
            mDataList = ArrayList<TestHomeCategoryBean>()
        } else {
            (mDataList as ArrayList).clear()
        }
        (mDataList as ArrayList<TestHomeCategoryBean>).addAll(bean.category!!)
        refreshView()
        setRealTextView(bean.body)
    }

    /**
     * 刷新View
     */
    private fun refreshView() {
        var i = 0
        if (null == imageViewCache) {
            imageViewCache = ArrayList()
        }
        if (null == textViewCache) {
            textViewCache = ArrayList()
        }
        var imageCount = imageViewCache!!.size
        for (item in this!!.mDataList!!) {
            if (i > 7) {
                break
            }
            if (i >= imageCount) {
                val imageView = createIcon(i)
                val textView = createText(i)

                (imageViewCache as ArrayList).add(imageView)
                (textViewCache as ArrayList).add(textView)
                fl_root.addView(imageView)
                fl_root.addView(textView)

                imageView.setOnClickListener {
                    testHomeEvent!!.categoryClick(item.categoryTab, i, item.categoryName, item.categoryId)
                }
                textView.setOnClickListener {
                    testHomeEvent!!.categoryClick(item.categoryTab, i, item.categoryName, item.categoryId)
                }
            }
            bindIconData(imageViewCache!!.get(i), item)
            bindTextData(textViewCache!!.get(i), item)
            i++
        }
    }

    /**
     * 创建图标
     */
    private fun createIcon(i: Int): ImageView {
        val imageParams = FrameLayout.LayoutParams(imageViewWidth, imageViewWidth)
        val imageView = ImageView(context)
        imageView.scaleType = ImageView.ScaleType.CENTER_CROP

        if (i > 3) {
            multiple = 2
            imageParams.topMargin = imageViewWidth + dp8 + textViewHeight
            imageParams.leftMargin = margin * (i - 3) + (i - 4) * (imageViewWidth + margin)
        } else {
            multiple = 1
            imageParams.leftMargin = margin * (i + 1) + i * (imageViewWidth + margin)
        }
        imageView.layoutParams = imageParams

        return imageView
    }

    /**
     * 加载图片
     */
    private fun bindIconData(imageView: ImageView, categoryBean: TestHomeCategoryBean) {
        GlideApp.with(context).load(categoryBean.categoryUrl).placeholder(R.drawable.tests_testhome_type_nor)
                .centerCrop().into(imageView)
    }

    /**
     * 创建文本
     */
    private fun createText(index: Int): TextView {
        val textParams = FrameLayout.LayoutParams(textViewWidth, textViewHeight)
        val textView = TextView(context)

        textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12f)
        textView.gravity = Gravity.CENTER_HORIZONTAL
        if (index > 3) {
            textParams.topMargin = 2 * (imageViewWidth + dp8) + textViewHeight
            textParams.leftMargin = textViewWidth * (index - 4)
        } else {
            textParams.topMargin = imageViewWidth + dp8
            textParams.leftMargin = textViewWidth * (index)
        }
        textView.layoutParams = textParams

        return textView
    }

    /**
     * 设置文本
     */
    private fun bindTextData(textView: TextView, categoryBean: TestHomeCategoryBean) {
        textView.text = categoryBean.categoryName
    }

    /**
     * 初始化实时测评状态View
     */
    private fun initRealTextView() {
        var realTestParam = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        realTestParam.topMargin = multiple * (imageViewWidth + dp8 + textViewHeight) + dp8 + RxImageTool.dip2px(10f)
        realTestView = TestHomeRealTestView(context, testHomeEvent!!)
        realTestView!!.layoutParams = realTestParam
    }

    private fun initLineView() {
        var lineParam = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, RxImageTool.dip2px(0.5f))
        var dp15 = RxImageTool.dip2px(15f)
        lineParam.leftMargin = dp15
        lineParam.rightMargin = dp15
        lineParam.topMargin = multiple * (imageViewWidth + dp8 + textViewHeight) + dp8
        lineView = View(context)
        lineView!!.setBackgroundColor(resources.getColor(R.color.tests_testhome_line))
        lineView!!.layoutParams = lineParam
    }

    /**
     * 实时测评状态赋值
     */
    private fun setRealTextView(list: List<TestHomeBodyBean>) {
        if (!hasRealTestView) {
            initLineView()
            fl_root.addView(lineView)
            initRealTextView()
            fl_root.addView(realTestView)
            hasRealTestView = true
        }
        realTestView!!.initData(list)
    }

    fun onDestory() {
        if (null == realTestView) {
            return
        }
        realTestView!!.onDestory()
    }
}