package com.yidianling.tests.home.widget

import android.content.Context
import android.os.Handler
import android.os.Looper
import android.os.Message
import android.view.View
import android.view.ViewGroup
import android.view.animation.Animation
import android.view.animation.DecelerateInterpolator
import android.view.animation.TranslateAnimation
import android.widget.FrameLayout
import com.yidianling.tests.R
import com.yidianling.tests.home.bean.TestHomeBodyBean
import com.yidianling.tests.home.event.ITestHomeEvent
import kotlinx.android.synthetic.main.tests_testhome_realtest_view_in.view.*
import kotlinx.android.synthetic.main.tests_testhome_realtest_view_out.view.*

/**
 * @author yuanwai
 * @描述:测评首页--实时测试状态View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/28
 */
class TestHomeRealTestView(mContext : Context,testHomeEvent : ITestHomeEvent) : FrameLayout(mContext){

    private val STATUS_IN = 0
    private val STATUS_OUT = 1
    private var curTipIndex = 0
    private var lastTimeMillis: Long = 0
    private val ANIM_DELAYED_MILLIONS = 2 * 1000
    /**
     * 动画持续时长
     */
    private val ANIM_DURATION = 500
    /**
     * 进、出 两个view (主要用于做动画，其实是两个相同的布局文件)
     */
    private var view_out: View? = null
    private var view_in:View? = null
    /**
     * 进、出 两个View 的动画
     */
    private var anim_out: Animation? = null
    private var anim_in:Animation? = null
    /**
     * 数据缓存
     */
    private var mDataList : List<TestHomeBodyBean>? = null

    private var testHomeEvent : ITestHomeEvent? = null

    private val mHandler: Handler = object : Handler(Looper.getMainLooper()) {
        override fun handleMessage(msg: Message?) {
            super.handleMessage(msg)
            updateTipAndPlayAnimation()
            sendMessageDelayed(Message(), ANIM_DELAYED_MILLIONS.toLong())
        }
    }

    init {
        this.testHomeEvent = testHomeEvent
        initView()
        initAnimation()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        var params = ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.WRAP_CONTENT)
        view_out = View.inflate(context, R.layout.tests_testhome_realtest_view_out,null)
        view_in = View.inflate(context, R.layout.tests_testhome_realtest_view_in,null)
        addView(view_out)
        addView(view_in)
        layoutParams = params
    }

    private fun initAnimation() {
        anim_out = newAnimation(0f, -1f)
        anim_in = newAnimation(1f, 0f)
        anim_in!!.setAnimationListener(object : Animation.AnimationListener {

            override fun onAnimationStart(animation: Animation) {

            }

            override fun onAnimationRepeat(animation: Animation) {

            }

            override fun onAnimationEnd(animation: Animation) {
                updateViewVisibility()
            }
        })
    }

    /**
     * 设置数据
     */
    fun initData(list: List<TestHomeBodyBean>){
        mHandler.removeCallbacksAndMessages(null)
        if (null == list || list.isEmpty()){
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        if (null == mDataList){
            mDataList = ArrayList()
        }else{
            (mDataList as ArrayList).clear()
        }
        (mDataList as ArrayList).addAll(list)
        curTipIndex = 0
        updateTip(STATUS_OUT)
        updateTipAndPlayAnimation()
        mHandler.sendMessageDelayed(Message(), ANIM_DELAYED_MILLIONS.toLong())
    }

    private fun updateViewVisibility() {
        if (curTipIndex % 2 == 0) {
            view_out!!.visibility = View.INVISIBLE
        } else {
            view_in!!.visibility = View.INVISIBLE
        }
    }

    private fun newAnimation(fromYValue: Float, toYValue: Float): Animation {
        val anim = TranslateAnimation(Animation.RELATIVE_TO_SELF, 0f, Animation.RELATIVE_TO_SELF, 0f,
                Animation.RELATIVE_TO_SELF, fromYValue, Animation.RELATIVE_TO_SELF, toYValue)
        anim.duration = ANIM_DURATION.toLong()
        anim.interpolator = DecelerateInterpolator()
        return anim
    }

    private fun updateTipAndPlayAnimation() {
        view_in!!.visibility = View.VISIBLE
        view_out!!.visibility = View.VISIBLE
        if (curTipIndex % 2 == 0) {
            updateTip(STATUS_OUT)
            view_in!!.startAnimation(anim_out)
            view_out!!.startAnimation(anim_in)
            this.bringChildToFront(view_in)
        } else {
            updateTip(STATUS_IN)
            view_out!!.startAnimation(anim_out)
            view_in!!.startAnimation(anim_in)
            this.bringChildToFront(view_out)
        }
    }

    private fun updateTip(status : Int){
        val bodyBean = getNextTip() ?: return

        when(status){
            STATUS_IN -> {

                tv_title_in.text = bodyBean.realTestTitle
                tv_name_in.text = getName(bodyBean.realTestName)
                view_in!!.setOnClickListener{
                    testHomeEvent!!.realTestClick(bodyBean.realTestLinkUrl,bodyBean.realTestTitle)
                }
            }
            STATUS_OUT -> {
                tv_title_out.text = bodyBean.realTestTitle
                tv_name_out.text = getName(bodyBean.realTestName)
                view_out!!.setOnClickListener{
                    testHomeEvent!!.realTestClick(bodyBean.realTestLinkUrl,bodyBean.realTestTitle)
                }
            }
        }
    }

    private fun getName(name : String?) : String{
        var nameBuffer = StringBuffer()
        nameBuffer.append(resources.getString(R.string.tests_testhome_just))
        nameBuffer.append(" ")
        nameBuffer.append(name)
        nameBuffer.append(" ")
        nameBuffer.append(resources.getString(R.string.tests_testhome_test))

        return nameBuffer.toString()
    }

    private fun getNextTip() : TestHomeBodyBean? {
        if (null == mDataList || mDataList!!.isEmpty()){
            return null
        }
        return mDataList!!.get(curTipIndex++ % mDataList!!.size)
    }

    fun onDestory(){
        mHandler.removeCallbacksAndMessages(null)
    }
}