package com.yidianling.tests.list.view.adapter

import android.content.Context
import android.graphics.Color
import androidx.recyclerview.widget.RecyclerView
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.adapter.MyBaseAdapter
import com.yidianling.common.tools.RxImageTool
import com.yidianling.tests.R

import com.yidianling.tests.home.utils.TestHomeUtils
import com.yidianling.tests.list.model.bean.Test
import kotlinx.android.synthetic.main.tests_testlist_item_view.view.*
import kotlinx.android.synthetic.main.tests_view_footview_loadmore.view.*


/**
 * 测试列表适配器
 * Created by zqk on 17-11-22.
 */
class TestListRecyclerAdapter(private val context: Context,
                              private val testList: MutableList<Test>,
                              private val pageType : Int
                            ) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    companion object {
        private val TYPE_HEADER= 1
        private val TYPE_FOOTER = 2
        private val TYPE_NORMAL = 0


        const val PAGE_TYPE_CATEGORY = 1
        const val PAGE_TYPE_SEARCH = 2


    }

    var onItemClickListener: MyBaseAdapter.OnItemClickListener<Test>? = null
    var hasMore = true
    var couponMoney  =""
    private var dp2 : Int? = 0
    private var dp5 : Int? = 0
    private var headerView: View? = null

    init {
        dp2 = RxImageTool.dip2px(2f)
        dp5 = RxImageTool.dip2px(5f)
    }

    fun setHeaderView(view: View) {
        headerView = view
        notifyDataSetChanged()
    }

    fun removeHeaderView() {
        headerView = null
        notifyDataSetChanged()
    }

    private fun hasHeader(): Boolean {
        return headerView != null
    }

    override fun getItemCount(): Int = if (testList.size > 0) testList.size + 1 + (if (hasHeader()) 1 else 0) else 0

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        if (holder is NormalViewHolder) {
            var newPosition = position - if (hasHeader()) 1 else 0
            val test = testList[newPosition]
            GlideApp.with(context)
                    .load(test.cover)
                    .dontAnimate()
                    .dontTransform()
//                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .placeholder(R.drawable.tests_default_img)
                    .into(holder.ivCover)
            holder.tvTitle.text = test.name
            holder.tvTestCount.text =TestHomeUtils.getNumNew(context, test.count)
            holder.tvTestContent.text = test.desc
            holder.tvHit.text = TestHomeUtils.getHitsNew(context, test.hits)
            setPrice(holder.tvPrice,holder.tvCoupon,test.price,test.isFree)

        } else if (holder is FootViewHolder) {
            if (hasMore) {
                holder.pbLoading.visibility = View.VISIBLE
                holder.ivNoMoreLeft.visibility = View.GONE
                holder.ivNoMoreRight.visibility = View.GONE
                holder.tvContent.text = context.getString(R.string.tests_loading)

            } else {
                holder.pbLoading.visibility = View.GONE
                holder.tvContent.text = context.getString(R.string.tests_load_end)
                holder.ivNoMoreLeft.visibility = View.VISIBLE
                holder.ivNoMoreRight.visibility = View.VISIBLE
            }
        }
    }

    private fun setPrice(textView : TextView,tvCoupon : TextView,price : String?,isFree : Int){
        if (TextUtils.isEmpty(price)){
            textView.visibility = View.INVISIBLE
            return
        }

        textView.visibility = View.VISIBLE
        if (isFree == 2
                ||price.equals("免费")
                ||TextUtils.isEmpty(price)
                ||"0".equals(price)
                ||"0.0".equals(price)
                ||"0.00".equals(price)){
            tvCoupon.visibility = View.GONE
            textView.setPadding(dp5!!,dp2!!,dp5!!,dp2!!)
            textView.text = "免费"
            textView.setBackgroundResource(R.drawable.tests_testhome_recom_price_bg)
            textView.setTextColor(Color.parseColor("#34CD65"))
        }else{
            var newPrice = TestHomeUtils.getOriginalPrice(tvCoupon,price,couponMoney)
            textView.setPadding(0,dp5!!,dp5!!,0)
            var priceContent = "￥$newPrice"
            TestHomeUtils.priceStyleNew(context,textView,priceContent, 1, priceContent.length)
            textView.setBackgroundResource(R.drawable.tests_testhome_null)
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return if (viewType == TYPE_HEADER)  {
            object : RecyclerView.ViewHolder(headerView!!) {}
        } else if (viewType == TYPE_NORMAL) {
            var view :View ?=null
            if (pageType== PAGE_TYPE_CATEGORY){
                view = LayoutInflater.from(parent?.context).inflate(R.layout.tests_item_category_testlist_view, parent, false)
            }else {
                view = LayoutInflater.from(parent?.context).inflate(R.layout.tests_testlist_item_view, parent, false)
            }
            NormalViewHolder(view!!)
        } else {
            val view = LayoutInflater.from(parent?.context).inflate(R.layout.tests_view_footview_loadmore, parent, false)
            FootViewHolder(view)
        }
    }

    override fun getItemViewType(position: Int): Int {
        return if (hasHeader() && position == 0) {
            return TYPE_HEADER
        }else if (position == testList.size + (if (hasHeader()) 1 else 0)) {
            TYPE_FOOTER
        } else {
            TYPE_NORMAL
        }
    }

    inner class NormalViewHolder(val view: View) : RecyclerView.ViewHolder(view) {
        var ivCover = view.ivCover
        var tvTitle = view.tv_title
        var tvTestCount = view.tv_num
        var tvTestContent = view.tvContent
        var tvHit = view.tv_hits
        var tvPrice = view.tv_price
        var tvCoupon = view.tv_coupon_money

        init {
            view.setOnClickListener {
                if (adapterPosition != RecyclerView.NO_POSITION) {
                    onItemClickListener?.onItemClickListener(view, adapterPosition- (if (hasHeader()) 1 else 0), testList[adapterPosition- (if (hasHeader()) 1 else 0)])
                }
            }
        }
    }

    inner class FootViewHolder(val view: View) : RecyclerView.ViewHolder(view) {
        var pbLoading = view.circle_progress
        var tvContent = view.tv_content
        var ivNoMoreLeft = view.iv_no_more_left
        var ivNoMoreRight = view.iv_no_more_right


    }
}