package com.yidianling.tests.list.view.widget

import android.content.Context
import android.graphics.drawable.BitmapDrawable
import androidx.recyclerview.widget.LinearLayoutManager
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.PopupWindow
import com.yidianling.tests.R
import com.yidianling.tests.list.model.bean.CategotyPopItem
import com.yidianling.tests.list.view.adapter.CategoryConditionRecyclerViewAdapter
import kotlinx.android.synthetic.main.tests_ui_category_sort_popup_window.view.*

/**
 * 排序弹窗
 * Created by zqk on 17-9-15.
 */
class CategoryPopupWindow(val context: Context,
                          private val items: ArrayList<CategotyPopItem>,
                          private val onItemSelectedListener: CategoryConditionRecyclerViewAdapter.OnItemSelectedListener)
    : PopupWindow(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT) {

    var adapter: CategoryConditionRecyclerViewAdapter

    init {
        val view = LayoutInflater.from(context).inflate(R.layout.tests_ui_category_sort_popup_window, null)
        this.contentView = view
        this.isFocusable = true
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true
        val rvSortItem = view.rvSortItem
        adapter = CategoryConditionRecyclerViewAdapter(context, items, onItemSelectedListener)
        rvSortItem.adapter = adapter
        rvSortItem.layoutManager =
            LinearLayoutManager(
                context,
                LinearLayoutManager.VERTICAL,
                false
            )
    }

    fun notifyDataSetChanged() {
        adapter.notifyDataSetChanged()
    }
}