package com.yidianling.user;

import android.annotation.SuppressLint;
import android.util.Log;
import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.data.http.ThrowableConsumer;
import com.ydl.ydlcommon.utils.BuryPointUtils;
import com.ydl.ydlcommon.utils.JPushUtils;
import com.ydl.ydlcommon.utils.log.LogHelper;
import com.yidianling.user.api.bean.UserResponseBean;
import com.yidianling.user.api.event.UserLoginEvent;
import com.yidianling.user.http.UserHttp;
import com.yidianling.user.http.UserHttpImpl;
import com.yidianling.user.http.request.ChannelIdParam;
import de.greenrobot.event.EventBus;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

import org.jetbrains.annotations.NotNull;

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/03/06
 */

public class LoginHelper {

    public static boolean isRegister;

    @SuppressLint("CheckResult")
    public static void setChannelId() {

        String channelId = JPushUtils.INSTANCE.getRegistrationID();
        if (UserHelper.INSTANCE.isLogin() && channelId != null) {

            UserHttp userHttp = UserHttpImpl.Companion.getInstance();
            userHttp.channelId(new ChannelIdParam(channelId))
                    .subscribeOn(Schedulers.io())
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribe(it -> {
                        if (it.data!=null){
                            if (it.data.get("upload_log").equals("1")) {
                                LogHelper.Companion.getInstance().uploadLog(false);
                            }
                            Log.d("TAG", "setChannelId: ");
                        }
                    }, new ThrowableConsumer() {
                        @Override
                        public void accept(@NotNull String msg) {
//                            ToastHelper.Companion.show(msg);
                        }
                    });
        }
    }

    public static void login(UserResponseBean response) {

        UserHelper.INSTANCE.setUserinfo(response);
        EventBus.getDefault().post(new UserLoginEvent("login",response.getUid()));

        BuryPointUtils.bindUid(String.valueOf(response.getUid()));
    }
}
