package com.yidianling.user

import android.text.TextUtils
import com.google.gson.Gson
import com.ydl.ydlcommon.utils.SharedPreferencesEditor
import com.ydl.ydlcommon.utils.UserInfoCache
import com.ydl.ydlcommon.utils.YdlBuryPointUtil
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.api.bean.UserSettingBean

/**
 * 用户信息辅助类
 */
object UserHelper {

    val gson: Gson = Gson()

    //用户信息存储
    private val user_info_name_sp = "ydl_user_info"
    private val user_info_key_sp = "ydl_user_info_key"

    //用户设置存储
    private val user_setting_name_sp = "ydl_user_setting"
    private val user_setting_key_sp = "ydl_user_setting_key"

    //用户信息//缓存
    private var userTemp: UserResponseBean? = null

    //用户设置信息缓存
    private var userSetting: UserSettingBean? = null

    //存储用户信息
    fun setUserinfo(userInfo: UserResponseBean?) {
        try {
            userTemp = userInfo
            var str = gson.toJson(userTemp)
            SharedPreferencesEditor.putFileString(user_info_name_sp, user_info_key_sp, str)

            UserInfoCache.getInstance().saveYDLUser("\"" + userInfo?.uid + "\"",
                    userInfo?.userInfo?.nick_name, userInfo?.userInfo?.head)

            YdlBuryPointUtil.reLogin()
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    //获取用户设置信息
    fun getUserInfo(): UserResponseBean? {
        if (userTemp != null) return userTemp!!
        try {
            var obj = SharedPreferencesEditor.getFileString(user_info_name_sp, user_info_key_sp)
            var app: UserResponseBean = gson.fromJson(obj, UserResponseBean::class.java)
            userTemp = app
            return userTemp!!
        } catch (e: Exception) {
            userTemp = UserResponseBean()
        }
        return userTemp
    }

    fun getUserInfoStr(): String? {
        if (userTemp != null) return gson.toJson(userTemp)
        return SharedPreferencesEditor.getFileString(user_info_name_sp, user_info_key_sp)
    }

    fun updateUserinfo(userInfo: UserResponseBean.UserInfo?) {
        getUserInfo()?.userInfo = userInfo
    }

    fun updateUserSetting(userseting: UserSettingBean?) {
        setUserSetting(userseting)
    }

    /**
     * 是否登录
     */
    fun isLogin(): Boolean {
        try {
            var user = getUserInfo()?.userInfo
            if (TextUtils.isEmpty(user?.uid)) {
                return false
            }
            var uid: Int = user?.uid?.toInt() ?: 0
            if (uid > 0) {
                return true
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return false
    }

    /**
     * 是否绑定手机
     */
    fun isBindPhone(): Boolean {
        return !TextUtils.isEmpty(getUserInfo()?.userInfo?.phone)
    }

    /**
     * 存储用户设置信息
     */
    fun setUserSetting(userseting: UserSettingBean?) {
        try {
            userSetting = userseting
            var str = gson.toJson(userSetting)
            SharedPreferencesEditor.putFileString(user_setting_name_sp, user_setting_key_sp, str)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    /**
     * 获取用户设置信息
     */
    fun getUsetSetting(): UserSettingBean? {
        if (userSetting != null) return userSetting!!
        try {
            var obj = SharedPreferencesEditor.getFileString(user_setting_name_sp, user_setting_key_sp)
            if (TextUtils.isEmpty(obj)) {
                setUserSetting(UserSettingBean())
            }
            var app: UserSettingBean = gson.fromJson(obj, UserSettingBean::class.java)
            userSetting = app
            return userSetting
        } catch (e: Exception) {
        }
        return userSetting
    }

    fun getUserSettingStr(): String? {
        if (userSetting != null) return gson.toJson(userSetting)
        return SharedPreferencesEditor.getFileString(user_setting_name_sp, user_setting_key_sp)
    }
}