package com.yidianling.user.http

import com.google.gson.Gson
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.http.request.*
import com.yidianling.user.http.response.ChcekPhoneResponeBean
import com.yidianling.user.http.response.PhoneAuthResponseBean
import io.reactivex.Observable
import okhttp3.MediaType
import okhttp3.RequestBody

/**
 * @author jiucheng
 * @描述:新版登录接口请求
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/11/9
 */
class LoginApiRequestUtil {
    companion object {
        private var userApi: UserApi? = null
        const val LOGIN_USER_PORT = "userPort:1"

        private fun getUserApi(): UserApi {
            if (userApi == null) {
                userApi = YDLHttpUtils.obtainApi(UserApi::class.java)
            }
            return userApi!!
        }

        /**
         * 校验手机号：是否是用户版号码、是否有设置密码、是否被绑定
         */
        fun checkPhoneStatus(phone: String, countryCode: String?): Observable<BaseResponse<ChcekPhoneResponeBean>> {
            return getUserApi().checkPhoneStatus(phone, countryCode!!)
        }

        /**
         * 校验手机号：是否是用户版号码、是否有设置密码、是否被绑定
         */
        fun checkAliAuth(param: CheckAliAuthParam): Observable<BaseResponse<PhoneAuthResponseBean>> {
            var str = Gson().toJson(param)
            val body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), str)
            return getUserApi().checkAliAuth(body)
        }

        /**
         *  一键登录
         */
        fun autoLogin(param: PhoneLoginAutoParam): Observable<BaseResponse<UserResponseBean>> {
            var str = Gson().toJson(param)
            val body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), str)
            return getUserApi().autoLogin(body)
        }

        /**
         *  手机号密码登录
         */
        fun userLoginByPassword(param: PhoneLoginPwdParam): Observable<BaseResponse<UserResponseBean>> {
            var str = Gson().toJson(param)
            val body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), str)
            return getUserApi().loginByPassword(body)
        }

        /**
         *  重新设置密码
         */
        fun resetPwd(param: PhoneResetPwdParam): Observable<BaseResponse<UserResponseBean>> {
            var str = Gson().toJson(param)
            val body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), str)
            return getUserApi().resetPwd(body)
        }

        /**
         * 发送登录验证码
         */
        fun sendLoginMsgCode(phone: String, countryCode: String): Observable<BaseResponse<Any>> {
            return getUserApi().sendLoginMsgCode(phone, countryCode)
        }

        /**
         * 验证码登录
         */
        fun loginByMsgCode(param: PhoneLoginCodeParam): Observable<BaseResponse<UserResponseBean>> {
            var str = Gson().toJson(param)
            val body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), str)
            return getUserApi().loginByMsgCode(body)
        }

        /**
         * 重置密码的验证码
         */
        fun sendResetCode(phone: String, countryCode: String): Observable<BaseResponse<Any>> {
            return getUserApi().sendResetCode(phone, countryCode)
        }

        /**
         * //验证重置密码的短信验证码
         */
        fun checkResetCode(phone: String, countryCode: String, msgCode: String): Observable<BaseResponse<Any>> {
            return getUserApi().checkResetCode(phone, countryCode, msgCode)
        }


        /**
         *  绑定手机号
         */
        fun bindPhone(param: BindPhoneJavaParam): Observable<BaseResponse<Any>> {
            var str = Gson().toJson(param)
            val body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), str)
            return getUserApi().bindPhone(body)
        }

        /**
         * 是否需要强绑手机号
         */
        fun isNeedForceBindPhone(map:Map<String,String>): Observable<BaseAPIResponse<Boolean>>{
            return getUserApi().isNeedForceBindPhone(map)
        }
    }
}