package com.yidianling.user.http

import com.google.gson.internal.LinkedTreeMap
import com.ydl.ydlcommon.base.config.*
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.bean.CollectFocusItemBean
import com.yidianling.user.http.LoginApiRequestUtil.Companion.LOGIN_USER_PORT
import com.yidianling.user.http.response.*
import com.yidianling.user.mine.bean.RedPacketId
import io.reactivex.Observable
import okhttp3.RequestBody
import retrofit2.http.*

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/02/02
 */
interface UserApi {

    //登录
    @FormUrlEncoded
    @POST("user/user")
    fun login(@FieldMap params: Map<String, String>): Observable<BaseResponse<UserResponseBean>>

    //国家列表
    @FormUrlEncoded
    @POST("user/country-list")
    fun countryList(@Field(YDLConstants.HOLDER_PARAM ) params: String): Observable<BaseResponse<CountryResponse>>

    //判断手机号是否存在
    @FormUrlEncoded
    @POST("user/phone-exist")
    fun phoneExists(@FieldMap params: Map<String, String>): Observable<BaseResponse<ExistResponse>>

    //获取验证码
    @FormUrlEncoded
    @POST("user/chk-code")
    fun getCode(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //绑定手机号
    @FormUrlEncoded
    @POST("user/bind-phone")
    fun bindPhone(@FieldMap params: Map<String, String>): Observable<BaseResponse<UserResponseBean>>

    //忘记密码
    @FormUrlEncoded
    @POST("user/forget")
    fun forget(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //注册
    @FormUrlEncoded
    @POST("user/reg")
    fun register(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //设置推送的channelId
    @POST("user/device/modify")
    @Headers( YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun setChannelId(@Body body: RequestBody): Observable<BaseResponse<LinkedTreeMap<String, String>>>



    //设置用户信息
    @FormUrlEncoded
    @POST("user/set-info")
    fun setUserInfo(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //上传头像
    @Multipart
    @POST("user/set-info")
    fun uploadHeadImg(@PartMap params: MutableMap<String, RequestBody>): Observable<BaseResponse<Any>>

    //上传头像
    @Multipart
    @POST("user/set-info")
    fun uploadHeadImg(@Part("type") param: RequestBody): Observable<BaseResponse<Any>>

    //验证账号密码
    @FormUrlEncoded
    @POST("user/chkin-pass")
    fun checkPhonePass(@FieldMap params: Map<String, String>): Observable<BaseResponse<CheckPassword>>

    //绑定QQ
    @FormUrlEncoded
    @POST("user/bind-qq")
    fun bindQQ(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //绑定微信
    @FormUrlEncoded
    @POST("user/bind-wx")
    fun bindWx(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //登出
    @FormUrlEncoded
    @POST("user/logout")
    fun logout(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //更换手机时密码验证
    @FormUrlEncoded
    @POST("user/confirm-pwd")
    fun checkPwd(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //更换手机时最后校验验证码和手机
    @FormUrlEncoded
    @POST("user/replace-mob")
    fun changePhone(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //同意隐私政策接口
    @GET("user/agreePrivacyAgreement")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun privacyAgree(@Query("uid") uid: String): Observable<BaseResponse<Any>>



    //服务端校验阿里一键认证
    @POST("phone/verification/init")
    fun checkAliAuth(@Body body: RequestBody): Observable<BaseResponse<PhoneAuthResponseBean>>

    //获取隐私政策数据
    @GET("site/get-privacy-content")
    fun getSecretData(): Observable<BaseResponse<SecretResponse>>

    //获取红包单号
    @FormUrlEncoded
    @POST("uc/ready-bonus")
    fun getRedPacketId(@FieldMap params: Map<String, String>): Observable<BaseResponse<RedPacketId>>


    //上传用户信息数据接口
    @POST("user/collect/submit")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun uploadUserInfo(@Body body: RequestBody): Observable<BaseAPIResponse<Any>>

    //获取关注问题数据接口
    @GET("cate/list-parentId")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun getFocusData(@Query("parentId") parentId: String = "0"): Observable<BaseAPIResponse<List<CollectFocusItemBean>>>

    //获取新用户引导页面url
    @FormUrlEncoded
    @POST("user/getNewUserJumpUrl")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun getNewUserJumpUrl(@FieldMap params: Map<String, String>): Observable<BaseAPIResponse<String>> //获取新用户引导页面url

    //第三方登录获取用户信息
    @POST("login/v2/login_wechat_qq")
    @Headers( YDL_DOMAIN+  YDL_DOMAIN_LOGIN_BASE_URL,LOGIN_USER_PORT)
    fun thirdPartJavaLogin(@Body body: RequestBody): Observable<BaseResponse<UserResponseBean>>

    /**
     * 绑定手机号
     */
    @POST("login/v2/bind_phone")
    @Headers(YDL_DOMAIN+ YDL_DOMAIN_LOGIN_BASE_URL, LOGIN_USER_PORT)
    fun bindPhone(@Body body: RequestBody): Observable<BaseResponse<Any>>

    /**
     * 一键登录和本机号码校验
     */
    @POST("login/v2/login_direct")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_LOGIN_BASE_URL, LOGIN_USER_PORT)
    fun autoLogin(@Body body: RequestBody): Observable<BaseResponse<UserResponseBean>>


    /**
     * 密码登录
     */
    @POST("login/v2/login_pwd")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_LOGIN_BASE_URL,LOGIN_USER_PORT)
    fun loginByPassword(@Body body: RequestBody): Observable<BaseResponse<UserResponseBean>>

    /**
     * 验证码登录
     */
    @POST("login/v2/login_sms")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_LOGIN_BASE_URL,LOGIN_USER_PORT)
    fun loginByMsgCode(@Body body: RequestBody): Observable<BaseResponse<UserResponseBean>>

    /**
     *  第三方登录
     */
    @POST("login/v2/login_wechat_qq")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_LOGIN_BASE_URL,LOGIN_USER_PORT)
    fun thirdPartyLogin(@Body body: RequestBody): Observable<BaseAPIResponse<UserResponseBean>>

    /**
     * 检查手机号来源
     */
    @GET("login/v2/phone_detection")
    @Headers(YDL_DOMAIN+ YDL_DOMAIN_LOGIN_BASE_URL,LOGIN_USER_PORT)
    fun checkPhoneStatus(@Query("phone") phone: String, @Query("countryCode") countryCode: String): Observable<BaseResponse<ChcekPhoneResponeBean>>

    /**
     * 验证重置密码的短信验证码
     */
    @GET("login/v2/pre_check_reset_sms")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_LOGIN_BASE_URL,LOGIN_USER_PORT)
    fun checkResetCode(@Query("phone") phone: String, @Query("countryCode") countryCode: String, @Query("code") code: String): Observable<BaseResponse<Any>>

    /**
     * 重置密码
     */
    @POST("login/v2/reset_pwd")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_LOGIN_BASE_URL, LOGIN_USER_PORT)
    fun resetPwd(@Body body: RequestBody): Observable<BaseResponse<UserResponseBean>>

    /**
     * 发送登录验证码
     */
    @GET("login/v2/send_login_sms")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_LOGIN_BASE_URL, LOGIN_USER_PORT)
    fun sendLoginMsgCode(@Query("phone") phone: String, @Query("countryCode") countryCode: String): Observable<BaseResponse<Any>>

    /**
     * 发送忘记密码重置密码的验证码
     */
    @GET("login/v2/send_reset_sms")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_LOGIN_BASE_URL,LOGIN_USER_PORT)
    fun sendResetCode(@Query("phone") phone: String, @Query("countryCode") countryCode: String): Observable<BaseResponse<Any>>

    /**
     * 第三方登录解绑
     */
    @POST("login/v2/unbind_wechat_qq")
    @Headers( YDL_DOMAIN+  YDL_DOMAIN_LOGIN_BASE_URL,LOGIN_USER_PORT)
    fun unBindThirdLogin(@Body body: RequestBody): Observable<BaseResponse<Any>>

    /**
     * 用户注销账号
     */
    @FormUrlEncoded
    @POST("user/forbid_login")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun userForbidLogin(@FieldMap params: Map<String, String>): Observable<BaseAPIResponse<Boolean>>

    /**
     * 是否需要强绑定手机号
     */
    @POST("login/v2/is_need_strong_bind")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_LOGIN_BASE_URL, LOGIN_USER_PORT)
    fun isNeedForceBindPhone(@Body map: Map<String,String>): Observable<BaseAPIResponse<Boolean>>
}