package com.yidianling.user.mine;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ydl.ydlcommon.view.dialog.CommonDialog;
import com.yidianling.user.R;
import com.yidianling.user.UserConstants;
import com.yidianling.user.UserHelper;
import com.yidianling.user.bean.FundData;
import com.yidianling.user.api.utils.UserApiServiceUtils;

/**
 * Created by softrice on 15/12/2.
 */
public class AccountHistoryListItemView extends LinearLayout {

    TextView tv_type;

    TextView tv_date;

    TextView tv_money_change;

    RelativeLayout relHead;
    RelativeLayout relDetail;
    TextView tvRecharge;
    TextView tvBalance;
    TextView tvStatus;
    TextView tvInfo;
    Activity mContext;
    View viewItem;
    View viewLast;

    public AccountHistoryListItemView(Context context) {
        super(context);
        mContext = (Activity) context;
        inflate(context, R.layout.user_mine_ui_account_history_list, this);
        tv_type = findViewById(R.id.tv_type);
        tv_date = findViewById(R.id.tv_date);
        tv_money_change = findViewById(R.id.tv_money_change);
        relHead = findViewById(R.id.rel_head);
        tvRecharge = findViewById(R.id.tv_recharge);
        tvBalance = findViewById(R.id.tv_balance);
        relDetail = findViewById(R.id.rl_detail_item);
        viewItem = findViewById(R.id.view_item);
        viewLast = findViewById(R.id.view_last);
        tvStatus = findViewById(R.id.tv_status);
        tvInfo = findViewById(R.id.tv_info);
    }


    public void setData(FundData.Fund fund) {
        relHead.setVisibility(GONE);
        relDetail.setVisibility(VISIBLE);
        tv_type.setText(fund.type);
        tv_date.setText(fund.create_time);
        tv_money_change.setText(fund.deal_money);
        tvStatus.setText(fund.status);
        if (TextUtils.isEmpty(fund.remark)) {
            tvInfo.setVisibility(GONE);
        } else {
            tvInfo.setVisibility(VISIBLE);
            tvInfo.setText(fund.remark);
        }

        //如果是提现的单
        if (TextUtils.equals("9", fund.type_int) || TextUtils.equals("10", fund.type_int)) {
            if (TextUtils.equals("2", fund.status_int)) {//审核中
                tvStatus.setTextColor(getResources().getColor(R.color.platform_main_theme));
            }
            if (!TextUtils.equals("2", fund.status_int) && !TextUtils.equals("5", fund.status_int)) {//未打款成功都算审核失败
                tvStatus.setTextColor(getResources().getColor(R.color.user_with_status_fail));
            }
            if (TextUtils.equals("5", fund.status_int)) {//审核成功
                tvStatus.setTextColor(getResources().getColor(R.color.platform_color_999999));
            }
        } else {
            tvStatus.setTextColor(getResources().getColor(R.color.platform_color_999999));
        }
    }

    public void setHeadData(String available) {
        relHead.setVisibility(VISIBLE);
        relDetail.setVisibility(GONE);
        tvBalance.setText(available);
        tvRecharge.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {

                //未绑定手机号弹窗提示去绑定
                if (!UserHelper.INSTANCE.isBindPhone()) {
                    CommonDialog.create(mContext)
                            .setLeftOnclick("忍痛放弃", null)
                            .setRightClick("果断绑定", new OnClickListener() {
                                @Override
                                public void onClick(View v) {
                                    mContext.startActivity( UserApiServiceUtils.INSTANCE.provideUserApiService().inputPhoneIntent(mContext, UserConstants.BIND_PHONE_ACTION));
                                }
                            })
                            .setMessage("\n为了您的账户安全，请先绑定手机\n")
                            .show();
                    return;
                }
                mContext.startActivity(new Intent(mContext, RechargeActivity.class));
            }
        });
    }

    public void setIsLast(boolean isLast) {
        if (isLast) {
            viewItem.setVisibility(GONE);
            viewLast.setVisibility(VISIBLE);
        } else {
            viewItem.setVisibility(VISIBLE);
            viewLast.setVisibility(GONE);
        }
    }
}
