package com.yidianling.user.mine

import android.annotation.SuppressLint
import android.view.Gravity
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.view.dialog.CommonDialog
import com.yidianling.common.tools.ToastUtil
import com.yidianling.user.R
import com.yidianling.user.event.UnRegisterEvent
import com.yidianling.user.http.UserHttpImpl
import com.yidianling.user.http.request.UserForbidLoginParam
import de.greenrobot.event.EventBus
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.activity_account_un_register.*

/**
 * 账号注销协议页面
 */
class AccountUnRegisterActivity : BaseActivity() {

    override fun layoutResId(): Int {
        return R.layout.activity_account_un_register
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(isAddStatusView = true, statusBarDarkMode = true)
    }

    override fun initDataAndEvent() {
        //无网络 读取本地文件
        web_view.loadUrl("file:///android_asset/html/accountUnregister.html")
        tv_unregister.setOnClickListener {

            CommonDialog(this)
                .setTitle("确定注销账号？")
                .setTitle_color(R.color.platform_color_242424)
                .setMessage(
                    """
                    1.您的账号内如有剩余金额，如未用完，视为放弃将被清零；

                    2.您的订单（已购买的咨询、课程、测评等）将被终止且无法继续接受服务；
                    """.trimIndent()
                )
                .setMessageTextGravity(Gravity.LEFT)
                .setMessageColor(R.color.platform_color_666666)
                .setLeftOnclick("下次再说") { }
                .setLeftButton_color(R.color.platform_color_666666)
                .setRightClick("确定") {
                    userForbidLogin()
                }
                .setRightButton_color(R.color.white)
                .setRightButtonBackgroundColor(R.color.baby_blue)
                .show()
        }
    }

    @SuppressLint("CheckResult")
    private fun userForbidLogin() {
        val param = UserForbidLoginParam()
        param.userPort = 1;
        UserHttpImpl.getInstance().userForbidLogin(param)
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe {
                if (!isFinishing && it.data) {
                    ToastUtil.toastShort("账号已注销")
                    EventBus.getDefault().post(UnRegisterEvent())
                    finish()
                }
            }
    }
}