package com.yidianling.user.mine

import android.annotation.SuppressLint
import android.content.Context
import android.content.Intent
import android.text.TextUtils
import android.view.View
import android.widget.ImageView
import android.widget.RelativeLayout
import com.alibaba.android.arouter.facade.annotation.Route
import com.ydl.ydl_image.config.SimpleImageOpConfiger
import com.ydl.ydl_image.manager.YDLImageCacheManager
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.yidianling.common.tools.RxImageTool
import com.yidianling.common.tools.ToastUtil
import com.yidianling.user.R
import com.yidianling.user.mine.bean.FeedBackDetailBean
import com.yidianling.user.mine.data.AppDataManager
import com.yidianling.user.mine.view.FeedBackPointDrawable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.user_mine_activity_my_feed_back.*

/**
 * @author jiucheng
 * @描述:我的反馈
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/15
 */
@Route(path = "/mine/MyFeedBackActivity")
class MyFeedBackActivity : BaseActivity() {
    private var feedBackId: String? = null
    private var leftView: ImageView? = null
    private var rightView: ImageView? = null

    companion object {
        private const val INTENT_ID = "intent_id"
        fun start(activity: Context, id: String) {
            var intent = Intent(activity, MyFeedBackActivity::class.java)
            intent.putExtra(INTENT_ID, id)
            activity.startActivity(intent)
        }
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true, true)
    }
    override fun layoutResId(): Int {
        return R.layout.user_mine_activity_my_feed_back
    }

    override fun initDataAndEvent() {
        feedBackId = intent.getStringExtra(INTENT_ID)

        if (TextUtils.isEmpty(feedBackId)) {
            ToastUtil.toastShort("参数错误，请重试")
            return
        }

        tb_title.setOnRightTextClick { _, _ ->
            run {
                startActivity(FeedBackActivity.newIntent(this))
            }
        }

        leftView = ImageView(this)
        leftView!!.setImageDrawable(FeedBackPointDrawable(true))
        rl_root_view.addView(leftView)

        rightView = ImageView(this)
        rightView!!.setImageDrawable(FeedBackPointDrawable(false))
        rl_root_view.addView(rightView)

        rl_root_view.post {
            setImageView(leftView!!, rightView!!)
        }
        getData()
    }

    private fun setImageView(leftView: ImageView, rightView: ImageView) {
        var left = rl_content.left
        var top = iv_line.top
        var leftLayoutParams = RelativeLayout.LayoutParams(RxImageTool.dp2px(12f), RxImageTool.dp2px(12f))
        leftLayoutParams.topMargin = top + rl_content.top - RxImageTool.dp2px(6f)
        leftLayoutParams.leftMargin = left - RxImageTool.dp2px(6f)
        leftView.layoutParams = leftLayoutParams

        var rightLayoutParams = RelativeLayout.LayoutParams(RxImageTool.dp2px(12f), RxImageTool.dp2px(12f))
        rightLayoutParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT)
        rightLayoutParams.topMargin = top + rl_content.top - RxImageTool.dp2px(6f)
        rightLayoutParams.rightMargin = left - RxImageTool.dp2px(6f)
        rightView.layoutParams = rightLayoutParams
    }

    @SuppressLint("CheckResult")
    private fun getData() {
        showProgressDialog()
        AppDataManager.getHttp().getFeedBackDetail(feedBackId!!)
//                .compose(RxUtils.resultData())
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({
                    dismissProgressDialog()
                    if (it.data != null) {
                        updateUi(it.data)
                    }
                }, {
                    dismissProgressDialog()
                    ToastUtil.toastShort(it.message)
                })
    }

    private fun updateUi(bean: FeedBackDetailBean) {
        tv_creat_time.text = bean.createTime
        tv_content.text = bean.content
        tv_name.text = bean.operator
        tv_finish_time.text = bean.finishTime
        tv_result.text = bean.processResult

        var option = SimpleImageOpConfiger()
        option.errorPic = R.drawable.platform_head_place_hold_pic
        option.loadingPic = R.drawable.platform_head_place_hold_pic
        option.transform = 0
        YDLImageCacheManager.showImage(this, "http://static.yidianling.com/mobile/images/avatar_girl_app.png", iv_head, option)
        if (!TextUtils.isEmpty(bean.image)) {
            iv_image.visibility = View.VISIBLE
            var imageOption = SimpleImageOpConfiger()
            imageOption.radius = RxImageTool.dp2px(5f)
            YDLImageCacheManager.showImage(this, bean.image, iv_image, imageOption)
        }
        rl_root_view.post {
            setImageView(leftView!!, rightView!!)
        }
    }
}
