package com.yidianling.user.mine;

import android.annotation.SuppressLint;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.data.http.ThrowableConsumer;
import com.ydl.ydlcommon.modular.ModularServiceManager;
import com.ydl.ydlcommon.utils.remind.ToastHelper;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.im.api.service.IImService;
import com.yidianling.user.R;
import com.yidianling.user.UserHelper;
import com.yidianling.user.http.UserHttp;
import com.yidianling.user.http.UserHttpImpl;
import com.yidianling.user.http.request.UserInfoParam;

import org.jetbrains.annotations.NotNull;

import io.reactivex.android.schedulers.AndroidSchedulers;


/**
 * 个人资料--个人简介
 * Created by hgw on 2017/3/24.
 */

public class PersonalDesActivity extends BaseActivity {

//    @BindView(R.id.image_back)
    ImageView imageBack;
//    @BindView(R.id.tv_center_title)
    TextView tvCenterTitle;
//    @BindView(R.id.text_save)
    TextView textSave;
//    @BindView(R.id.rela_toolBar)
    RelativeLayout relaToolBar;
//    @BindView(R.id.edit_des)
    EditText editDes;
    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }
    @Override
    protected int layoutResId() {
        return R.layout.user_mine_activity_personal_des;
    }

    @Override
    protected void initDataAndEvent() {
        imageBack = findViewById(R.id.image_back);
        tvCenterTitle = findViewById(R.id.tv_center_title);
        editDes = findViewById(R.id.edit_des);
        textSave = findViewById(R.id.text_save);
        imageBack.setOnClickListener(v -> {
            finish();
        });
        textSave.setOnClickListener(v -> {
            updateInfo("home_desc", editDes.getText().toString());
        });
        init();
    }


    private void init() {
        String desc = "";
        try {
            desc = ModularServiceManager.INSTANCE.provide(IImService.class).getUserInfoDescription();
        } catch (Exception e) {}
        editDes.setText(desc);
    }

    @SuppressLint("CheckResult")
    private void updateInfo(final String changType, final String value) {
        showProgressDialog("保存中");
        UserHttp userHttp = UserHttpImpl.Companion.getInstance();
        userHttp.setUserInfo(new UserInfoParam(changType, value))
                .filter(objectBaseResponse -> changType.equals("home_desc"))
                .compose(RxUtils.resultData())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(o -> {
                    dismissProgressDialog();
                    UserHelper.INSTANCE.getUserInfo().getUserInfo().setDescription(value);
                    ToastUtil.toastShort("保存成功");
                    finish();
                }, new ThrowableConsumer() {
                    @Override
                    public void accept(@NotNull String msg) {
                        dismissProgressDialog();
                        ToastHelper.Companion.show(msg);
                    }
                });
    }
}
