package com.yidianling.user.mine;

import android.content.Intent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;

import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.view.DeleteEditTextView;
import com.ydl.ydlcommon.view.TitleBar;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.user.R;

import org.jetbrains.annotations.NotNull;

/**
 * 短信息填写
 * Created by softrice on 15/9/29.
 */
public class SetInfoActivity extends BaseActivity {
    public static final String INPUT = "INPUT";
    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }
    public static Intent getIntent(String input) {
        Intent intent = new Intent();
        intent.putExtra(INPUT, input);
        return intent;
    }

    public static String getInput(Intent intent) {
        if (intent == null) {
            return null;
        }
        return intent.getStringExtra(INPUT);
    }

    String mTitle;
    String mOldString;

//    @BindView(R.id.det_set_info)
    DeleteEditTextView det_set_info;
//    @BindView(R.id.tb_title_bar)
    TitleBar tb_title_bar;

    Animation shake;

    @Override
    protected int layoutResId() {
        return R.layout.user_mine_activity_set_info;
    }

    @Override
    protected void initDataAndEvent() {
        det_set_info = findViewById(R.id.det_set_info);
        tb_title_bar = findViewById(R.id.tb_title_bar);
        mTitle = getIntent().getStringExtra("mTitle");
        mOldString = getIntent().getStringExtra("mOldString");
        init();
    }


    void init() {

        shake = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.user_mine_shake);

        tb_title_bar.setTitle(mTitle);
        det_set_info.setText(mOldString);

        tb_title_bar.setOnRightTextClick(new TitleBar.OnTitleBarTextClick() {
            @Override
            public void onClick(View view, boolean isActive) {
                if (checkInput()) {
                    ToastUtil.toastShort("保存成功");
                    setResult(RESULT_OK, getIntent(det_set_info.getText().toString()));
                    finish();
                }
            }
        });

    }

    boolean checkInput() {
        if (det_set_info.getText().length() == 0) {
            ToastUtil.toastShort("请输入昵称");
            det_set_info.startAnimation(shake);
            return false;
        }

        if (det_set_info.getText().length() > 6) {
            ToastUtil.toastShort("昵称最多6个字哦");
            det_set_info.startAnimation(shake);
            return false;
        }
        return true;
    }

}
