package com.yidianling.user.mine.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import com.yidianling.user.mine.APPWillUpParam;
import com.ydl.ydlcommon.bean.VersionData;
import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.data.http.ThrowableConsumer;
import com.ydl.ydlcommon.utils.remind.ToastHelper;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.user.mine.data.AppDataManager;

import org.jetbrains.annotations.NotNull;

import io.reactivex.android.schedulers.AndroidSchedulers;


/**
 * app版本更新的工具类
 * Created by Administrator on 2016/6/14.
 */
public class UpdateUtil {

    private VersionUpdateListener updateListener;
    private static UpdateUtil updateUtil;

    public static UpdateUtil getInstance() {
        if (updateUtil == null) {
            synchronized (UpdateUtil.class) {
                if (updateUtil == null) {
                    updateUtil = new UpdateUtil();
                }
            }
        }
        return updateUtil;
    }

    //设置检查更新的监听，必须在checkVersion()方法前
    public void setUpdateListener(Context context, VersionUpdateListener updateListener) {
        this.updateListener = updateListener;
        checkVersion(context);
    }

    //从服务器获取版本信息
    @SuppressLint("CheckResult")
    private void checkVersion(Context context) {

        AppDataManager.INSTANCE.getHttp().appWillUp(new APPWillUpParam(2))
                .compose(RxUtils.resultData())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(mustUP -> {
                    updateListener.setUpdateData(mustUP.version);
                }, new ThrowableConsumer() {
                    @Override
                    public void accept(@NotNull String msg) {
                        updateListener.onFailed();
                        ToastHelper.Companion.show(msg);
                    }
                });

    }

    //是否需要更新
    public boolean needUpdate(Context context, String version) {
        boolean isUpdate;
        String currentVersion = getAppVersionName(context);
        return version.compareTo(currentVersion) > 0;
    }

//    /**
//     * 返回当前程序版本号
//     */
//    public int getAppVersionCode(Context context) {
//        PackageInfo packageInfo = getPackageInfo(context);
//        int versionCode = 0;
//        if (packageInfo != null) {
//            versionCode = getPackageInfo(context).versionCode;
//        }
//        return versionCode;
//    }

    /**
     * 返回当前程序版本名
     */
    public String getAppVersionName(Context context) {
        PackageInfo packageInfo = getPackageInfo(context.getApplicationContext());
        String versionName;
        if (packageInfo != null) {
            versionName = packageInfo.versionName;
            if (versionName == null || versionName.length() <= 0) {
                versionName = "";
            }
        } else {
            versionName = "";
        }
        return versionName;
    }

    //获取当前程序的包信息
    private PackageInfo getPackageInfo(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            return pm.getPackageInfo(context.getPackageName(), 0);
        } catch (PackageManager.NameNotFoundException e) {
            LogUtil.d(e.getMessage());
        }
        return null;
    }

    //监听版本更新的接口
    public interface VersionUpdateListener {
        void setUpdateData(VersionData version);

        void onFailed();
    }
}
