package com.yidianling.user.mine.view

import android.annotation.SuppressLint
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.ColorFilter
import android.graphics.Paint
import android.graphics.drawable.Drawable
import com.yidianling.common.tools.RxImageTool

/**
 * @author jiucheng
 * @描述:自定义圆点绘制
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/18
 */
class FeedBackPointDrawable : Drawable {
    /**
     * 边框是否在在左边
     */
    private var isLeft = false
    /**
     * 用于边框和背景的画笔
     */
    private var paint: Paint? = null
    private var otherPaint: Paint? = null

    constructor(isLeft: Boolean) : super() {
        this.isLeft = isLeft
        initArc()
    }


    private fun initArc() {
        paint = Paint()
        paint!!.isAntiAlias = true
        paint!!.color = Color.parseColor("#F0F0F0")
        paint!!.style = Paint.Style.FILL
        otherPaint = Paint()
        otherPaint!!.isAntiAlias = true
        otherPaint!!.color = Color.parseColor("#E0E0E0")
        otherPaint!!.style = Paint.Style.STROKE
        otherPaint!!.strokeWidth = RxImageTool.dp2px(0.5f).toFloat()
    }

    @SuppressLint("NewApi")
    override fun draw(canvas: Canvas?) {
        canvas!!.drawCircle(bounds.exactCenterX(), bounds.exactCenterY(), bounds.exactCenterX(), paint)
        if (isLeft) {
            canvas!!.drawArc(0.5f, 0.5f, bounds.exactCenterX() * 2-0.5f, bounds.exactCenterY() * 2-0.5f, -90f, 180f, false, otherPaint)
        } else {
            canvas!!.drawArc(0.5f, 0.5f, bounds.exactCenterX() * 2-0.5f, bounds.exactCenterY() * 2-0.5f, 90f, 180f, false, otherPaint)
        }
    }

    override fun setAlpha(alpha: Int) {
    }

    @SuppressLint("WrongConstant")
    override fun getOpacity(): Int {
        return 0
    }

    override fun setColorFilter(colorFilter: ColorFilter?) {
    }
}