package com.yidianling.user.safePrivate

import android.text.TextUtils
import android.view.View
import android.widget.TextView
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.view.CircleImageView
import com.ydl.ydlcommon.view.TitleBar
import com.ydl.ydlcommon.view.dialog.CommonDialog
import com.yidianling.user.R
import com.yidianling.user.UserHelper
import com.yidianling.user.route.UserIn
import com.yidianling.user.ui.login.RegisterAndLoginActivity

/**
 * 登录验证指纹
 */
class FingerPrintCheckActivity : BaseActivity(), View.OnClickListener {
    override fun initDataAndEvent() {
        isFromBackground = intent.getBooleanExtra("isFromBackground", false)

        init()
    }

    override fun layoutResId(): Int {
        return R.layout.user_activity_finger_print_check
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true,true)
    }
    //是否来自于后台启动验证
    var isFromBackground = false

    lateinit var title_bar: TitleBar
    var headImg: CircleImageView? = null
    var checkText: TextView? = null
    var loginText: TextView? = null

    //错误次数 最多三次
    var error_num = 3


    override fun onDestroy() {
        super.onDestroy()
    }

    fun init() {
        title_bar = findViewById<TitleBar>(R.id.title_bar)
        headImg = findViewById<CircleImageView>(R.id.head_img)
        checkText = findViewById<TextView>(R.id.text_check)
        loginText = findViewById<TextView>(R.id.text_login)

        //设置头像
        val head = UserHelper.getUserInfo()?.userInfo?.head
        if (!TextUtils.isEmpty(head)) {
            GlideApp.with(mContext).load(head).into(headImg)
        }

        checkText?.setOnClickListener(this)
        loginText?.setOnClickListener(this)

        //开始验证
        checkFinger()
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.text_check -> {
                //弹出验证
                checkFinger()
            }
            R.id.text_login -> {
                //跳转登录验证
                RegisterAndLoginActivity.start(this)
//                finish()
            }
        }
    }

    //弹窗开始验证
    fun checkFinger() {

        //如果系统指纹功能被关闭（关闭状态下指纹会被清除的），则提示
        if (FingerPrintUtil.instance().isHaveFingerPrint() ?: false == false) {
            //锁屏密码已关闭
            CommonDialog(mContext)
                    .setMessage("\n您的指纹信息发生变更,请在手机中重新添加指纹后返回解锁,或切换登录方式")
                    .setRightClick("确定") {
                    }
                    .setCancelAble(false)
                    .show()
            return
        }

        //进入其他页面返回后验证错误次数
        if (error_num < 1) {
            CommonDialog(mContext)
                    .setMessage(FingerPrintUtil.errorLogin)
                    .setMessageColor(R.color.platform_price_color)
                    .setRightClick("确定") {
                        //跳转登录
                        RegisterAndLoginActivity.start(this)
                        //                                finish()
                    }
                    .setCancelAble(false)
                    .show()
            return
        }

        //判断系统指纹是否被暂时禁止
        if (!FingerPrintUtil.getFingerPrintIsAviable()) {
            CommonDialog(mContext)
                    .setImageCenter(R.drawable.user_lock_ico_zhiwen)
                    .setMessage(FingerPrintUtil.errorMoreMessage)
                    .setMessageColor(R.color.platform_price_color)
                    .setRightClick("取消") {
                        //停止指纹监听
                        FingerPrintUtil.instance().cancelFingerListener()
                    }
                    .show()
            return
        }

        var dia = CommonDialog(mContext)
                .setImageCenter(R.drawable.user_lock_ico_zhiwen)
                .setMessage("验证已有手机指纹")
                .setRightClick("取消") {
                }
                .setOnDismiss {
                    //停止指纹监听
                    FingerPrintUtil.instance().cancelFingerListener()
                }
        dia.show()

        FingerPrintUtil.instance().startFingerPrint(object : FingerPrintUtil.FingerCallback {
            override fun onAuthenticationSucceeded() {
                //
                FingerPrintUtil.instance().setCurrentUnLockTime(System.currentTimeMillis())
                if (!isFromBackground) {
                    UserIn.splashIntent(this@FingerPrintCheckActivity)
                }
                //关闭手势解锁页面与指纹解锁页面
//                EventBus.getDefault().post(FinishActivityEvent(FingerPrintCheckActivity::class.simpleName))
//                EventBus.getDefault().post(FinishActivityEvent(HandUnlockCheckActivity::class.simpleName))
                if (!isFinishing && dia != null) {
                    dia.dismiss()
                    dia = null
                }
                finish()
            }

            override fun onAuthenticationFailed() {
                if (dia != null) {
                    dia.setMessage(FingerPrintUtil.errorMessage).setMessageColor(R.color.platform_price_color)
                    //设置抖动动画
                    dia.setMessageShake(true)
                }
                error_num--
                if (error_num < 1) {
                    //关闭指纹监听
                    FingerPrintUtil.instance().cancelFingerListener()
                    //错误次数太多
                    if (dia != null) {
                        dia.dismiss()
                    }
                    CommonDialog(mContext)
                            .setMessage(FingerPrintUtil.errorLogin)
                            .setMessageColor(R.color.platform_price_color)
                            .setRightClick("确定") {
                                //跳转登录
                                //跳转登录
                                RegisterAndLoginActivity.start(this@FingerPrintCheckActivity)
                            }
                            .setCancelAble(false)
                            .show()
                }
            }

            override fun onAuthenticationError() {
                if (dia != null) {
                    dia.setMessage(FingerPrintUtil.errorMoreMessage).setMessageColor(R.color.platform_price_color)
                }
            }

        })
    }

    override fun onBackPressed() {

    }
}
