package com.yidianling.user.ui.login.model

import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.http.LoginApiRequestUtil
import com.yidianling.user.http.request.BindPhoneJavaParam
import com.yidianling.user.http.request.PhoneLoginCodeParam
import com.yidianling.user.ui.login.contract.IVerificationCodeContract
import io.reactivex.Observable

/**
 * @author jiucheng
 * @描述:登录model
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/11/29
 */
class VerificationCodeModelImpl : IVerificationCodeContract.Model {

    /**
     * 绑定手机号
     */
    override fun bindPhone(param: BindPhoneJavaParam): Observable<BaseResponse<Any>> {
        return LoginApiRequestUtil.bindPhone(param)
    }

    /**
     *
     * 检查重置密码的验证码(重置密码就是忘记密码)
     */
    override fun checkResetCode(phone: String, countryCode: String, msgCode: String): Observable<BaseResponse<Any>> {
        return LoginApiRequestUtil.checkResetCode(phone, countryCode, msgCode)
    }

    /**
     * 重置密码的验证码
     */
    override fun sendResetCode(phone: String, countryCode: String): Observable<BaseResponse<Any>> {
        return LoginApiRequestUtil.sendResetCode(phone, countryCode)
    }

    /**
     * 验证码验证码登录
     */
    override fun loginByMsgCode(param: PhoneLoginCodeParam): Observable<BaseResponse<UserResponseBean>> {
        return LoginApiRequestUtil.loginByMsgCode(param)
    }

    /**
     * 发送登录验证码
     */
    override fun sendLoginMsgCode(phone: String, countryCode: String): Observable<BaseResponse<Any>> {
        return LoginApiRequestUtil.sendLoginMsgCode(phone, countryCode)
    }

}