package com.yidianling.user.widget

import android.app.Activity
import android.app.Dialog
import android.content.Intent
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.text.Spannable
import android.text.SpannableString
import android.text.TextPaint
import android.text.TextUtils
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.view.View
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.common.tools.LogUtil
import com.yidianling.user.LoginUtils
import com.yidianling.user.R
import com.yidianling.user.UserHelper
import com.yidianling.user.http.UserHttpImpl
import com.yidianling.user.ui.login.H5Activity
import com.yidianling.user.ui.login.RegisterAndLoginActivity
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.user_dialog_privacy.*

/**
 * @author jiucheng
 * @描述:隐私确认弹窗
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/5
 */
class PrivacyDialog : Dialog {
    private var activity: Activity? = null
    private var des: String? = null
    private var updateDes: String? = null

    constructor(activity: Activity?, des: String?, updateDes: String?) : super(activity) {
        this.activity = activity
        this.des = des
        this.updateDes = updateDes
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.user_dialog_privacy)
        setCanceledOnTouchOutside(false)
        window.setBackgroundDrawable(ColorDrawable())

        if (!TextUtils.isEmpty(des)) {
            if (des!!.contains("《壹点灵隐私政策》")) {
                var index = des!!.indexOf("《壹点灵隐私政策》")
                val spannableString = SpannableString(des)
                spannableString.setSpan(object : ClickableSpan() {
                    override fun updateDrawState(ds: TextPaint) {
                        super.updateDrawState(ds)
                        ds.color = Color.parseColor("#1C98E6")
                        ds.isUnderlineText = false
                    }

                    override fun onClick(widget: View) {
                        H5Activity.start(activity, true)
                        activity!!.overridePendingTransition(R.anim.platform_slide_in_from_bottom, R.anim.user_slide_null)
                    }
                }, index, index + 9, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)

                tv_des.text = spannableString
                tv_des.movementMethod = LinkMovementMethod.getInstance()
            }
        } else {
            tv_des.text = des
        }

        if (TextUtils.isEmpty(updateDes)) {
            tv_update_des.visibility = View.GONE
        }
        tv_update_des.text = updateDes
        tv_disagree.setOnClickListener {
            dismiss()
            LogOut()
        }
        tv_agree.setOnClickListener {
            agree()
        }
    }


    /**
     * 退出登录
     */
    private fun LogOut() {
        //清除UserInfo
        UserHelper.setUserinfo(null)
        LoginUtils.logout()
        activity!!.startActivity(Intent(activity, RegisterAndLoginActivity::class.java))
    }


    /**
     * 同意，向服务端发送
     */
    private fun agree() {
        var uid = ""
        if (UserHelper.getUserInfo() != null && !TextUtils.isEmpty(UserHelper.getUserInfo()!!.uid)) {
            uid = UserHelper.getUserInfo()!!.uid!!
        } else {
            val loginBean = ModularServiceManager.getPlatformUserService()?.getUser()
            if (loginBean != null) {
                uid = loginBean.userId
            }
        }

        UserHttpImpl.getInstance().privacyAgree(uid)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .doOnSubscribe { (activity as BaseActivity).showProgressDialog() }
                .doAfterTerminate {
                    (activity as BaseActivity).dismissProgressDialog()
                    dismiss()
                }
                .subscribe({
                    if (it.code == 200) {
                        UserHelper.getUserInfo()!!.userInfo!!.privacyAgreementStatus = 1
                    }
                }, {
                    LogUtil.e(it.message)
                })
    }

    override fun show() {
        if (null == activity || activity!!.isFinishing) {
            return
        }
        super.show()
    }
}