package com.ydl.media.audio


import com.ydl.media.audio.model.Music

/**
 * Created by haorui on 2019-10-27 .
 * Des:播放进度监听器
 */
interface OnPlayerEventListener {

    /**
     * 切换歌曲
     */
    fun onChange(music: Music)

    /**
     * 继续播放
     */
    fun onPlayerStart()

    /**
     * 暂停播放
     */
    fun onPlayerPause()

    /**
     * 更新进度
     * percent : 播放百分比
     * currentPosition：当前播放位置
     */
    fun onPublish(percent: Int,currentPosition: Long)

    /**
     * 缓冲百分比
     */
    fun onBufferingUpdate(percent: Int)

    /**
     * 准备完成
     *
     * duration:音乐时长
     */
    fun onPrepared(duration:Long)

    /**
     * 单曲播放完成
     */
    fun onComplete()
}
