package com.ydl.media.audio.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.text.TextUtils

import com.ydl.media.audio.AudioPlayer


/**
 * Created by haorui on 2019-10-27 .
 * Des: 通知栏事件监听
 */
class StatusBarReceiver : BroadcastReceiver() {

    override fun onReceive(context: Context, intent: Intent?) {
        if (intent == null || TextUtils.isEmpty(intent.action)) {
            return
        }

        val extra = intent.getStringExtra(EXTRA)
        if (TextUtils.equals(extra, EXTRA_NEXT)) {
            AudioPlayer.get().next()
        } else if (TextUtils.equals(extra, EXTRA_PLAY_PAUSE)) {
            AudioPlayer.get().playPause()
        }
    }

    companion object {
        val ACTION_STATUS_BAR = "com.ydl.media.STATUS_BAR_ACTIONS"
        val ACTION_MUSIC_CLICK = "com.ydl.media.ACTION_MUSIC_CLICK"
        val EXTRA = "extra"
        val EXTRA_NEXT = "next"
        val EXTRA_PLAY_PAUSE = "play_pause"
    }
}
