package com.ydl.ydlnet.client.observer;

import com.ydl.ydlnet.client.bean.BaseData;

import io.reactivex.disposables.Disposable;

/**
 * Created by haorui on 2019-09-02 .
 * Des:  常用数据格式 通用Observer
 *
 * JSON格式
 *      {
 *      "code":200,
 *      "msg":"成功"
 *       "data":{
 *             "userName":"test"
 *             "token":"abcdefg123456789"
 *             "uid":"1"
 *             }
 *      }
 */
public abstract class DataObserver<T> extends BaseObserver<BaseData<T>> {

    /**
     * 失败回调
     *
     * @param errorMsg 错误信息
     */
    protected abstract void onError(String errorMsg);

    /**
     * 成功回调
     *
     * @param data 结果
     */
    protected abstract void onSuccess(T data);

    @Override
    public void doOnSubscribe(Disposable d) {
    }

    @Override
    public void doOnError(String errorMsg) {
        onError(errorMsg);
    }

    @Override
    public void doOnNext(BaseData<T> data) {
        String codeStr = String.valueOf(data.getCode());
        if("0".equals(codeStr)||"200".equals(codeStr)) {
            onSuccess(data.getData());
        }else {
            onError(data.getMsg());
        }
    }

    @Override
    public void doOnCompleted() {
    }


}
