package com.yidianling.ydl_pay.common.bean.params;

import android.text.TextUtils;

import com.ydl.ydlcommon.base.BaseApp;
import com.ydl.ydlcommon.base.config.YDLConstants;

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/4/24
 */
public class WxPayParam extends CommonPayParam {
    public WxPayParam(String payId, int isThreePay,String merchantType) {
        super(payId, "wxapp_hz", isThreePay,merchantType);
        if(!TextUtils.isEmpty(BaseApp.instance.getGlobalConfig().getAppWxPayType())) {
            type =BaseApp.instance.getGlobalConfig().getAppWxPayType();
        }else {
            if (YDLConstants.FROM_XLZX.equals(BaseApp.instance.getGlobalConfig().getAppFrom())) {
                type = "wxapp_consult";
            } else if(YDLConstants.FROM_YDL.equals(BaseApp.instance.getGlobalConfig().getAppFrom())) {
                type = "wxapp_hz";
            }
        }
    }
}
