package com.yidianling.ydl_pay.common.toast

import android.content.Context
import androidx.annotation.StringRes
import android.widget.Toast
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.utils.LogUtil
import com.yidianling.common.tools.ToastUtil

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/01/29
 *
 * 提示信息的封装类，使用单例 toast，防止重复弹出提示
 */
class ToastHelper private constructor() {

    private var toast: Toast? = null

    companion object {
        private fun getInstance(): ToastHelper {
            return Holder.INSTANCE
        }

        fun show(context: Context, text: String) {
            getInstance()
                .show(context.applicationContext, text)
        }

        fun show(context: Context, @StringRes resId: Int) {
            getInstance()
                .show(context.applicationContext, resId)
        }
    }

    private fun show(context: Context, text: CharSequence) {
        ToastUtil.toastShort(text.toString())
    }

    private fun show(context: Context, @StringRes resId: Int) {
        try {
            val text  = BaseApp.getApp().resources.getString(resId)
            ToastUtil.toastShort(text)
        } catch (e: Exception) {
            LogUtil.e(e.message)
        }
    }

    private object Holder {
        val INSTANCE = ToastHelper()
    }
}
