package com.ydl.ydlcommon.base.config

import android.content.Context
import com.ydl.ydlcommon.base.delegate.IAppLifecycles

/**
 * Created by haorui on 2019-08-22 .
 * Des: 组件自定义参数配置类，实现 IConfigModule 后,在 AndroidManifest 中声明该实现类
 */
interface IConfigModule {

    /**
     * module 自定义 参数配置
     *
     * @param context [Context]
     * @param builder [GlobalConfig.Builder]
     */
    fun applyOptions(context: Context, builder: GlobalConfig.Builder)

    /**
     *  Application 的生命周期中注入一些操作
     *
     * @param context
     * @param lifecycles Application 生命周期容器, 可添加多个
     */
    fun injectAppLifecycle(context: Context, lifecycles: MutableList<IAppLifecycles>)
}
