package com.ydl.ydlcommon.data

import com.meituan.android.walle.WalleChannelReader
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.bean.GlobalInfo
import com.ydl.ydlcommon.router.YdlCommonOut

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/05/03
 */
class PlatformRamImpl private constructor(): IPlatformRam {

    private var globalInfo: GlobalInfo? = null

    companion object {
        fun getInstance(): PlatformRamImpl {
            return Holder.INSTANCE
        }
    }

    override fun getGlobalInfo(): GlobalInfo? {
        return globalInfo
    }

    override fun setGlobalInfo(globalInfo: GlobalInfo) {
        this.globalInfo = globalInfo
    }

    private val ydlChannel: String by lazy {
        val appFrom = BaseApp.instance.getGlobalConfig().appFrom;
        var channel = WalleChannelReader.getChannel(YdlCommonOut.getApp())

        if (channel.isNullOrEmpty()){
            channel = "${appFrom}_zhuzhan"
            return@lazy channel!!
        }

        channel = appFrom+"_"+channel
        channel ?: "android"
    }

    override fun getChannelName(): String {
        return ydlChannel
    }

    private object Holder {
        val INSTANCE = PlatformRamImpl()
    }
}