package com.ydl.ydlcommon.data.http

import java.security.MessageDigest
import java.security.NoSuchAlgorithmException


/**
 * 加密相关方法
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/01/06
 */
object EncryptUtils {

    private val hexDigits by lazy {
        charArrayOf('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f')
    }

    /**
     * MD5 加密
     *
     * @param data 明文字符串
     * @return 16 进制密文
     */
    @JvmStatic
    fun encryptMD5ToString(data: String): String {
        return encryptMD5ToString(data.toByteArray(charset("utf-8")))
    }

    /**
     * MD5 加密
     *
     * @param data 明文字节数组
     * @return 16 进制密文
     */
    @JvmStatic
    fun encryptMD5ToString(data: ByteArray): String {
        return bytes2HexString(
            encryptMD5(
                data
            )
        )
    }

    /**
     * MD5 加密
     *
     * @param data 明文字节数组
     * @return 密文字节数组
     */
    @JvmStatic
    fun encryptMD5(data: ByteArray): ByteArray {
        return hashTemplate(data, "MD5")
    }

    /**
     * hash 加密模板
     *
     * @param data      数据
     * @param algorithm 加密算法
     * @return 密文字节数组
     */
    private fun hashTemplate(data: ByteArray, algorithm: String): ByteArray {
//        if (data == null || data.isEmpty()) return null
        return try {
            val md = MessageDigest.getInstance(algorithm)
            md.update(data)
            md.digest()
        } catch (e: NoSuchAlgorithmException) {
            e.printStackTrace()
            ByteArray(0)
        }
    }


    private fun bytes2HexString(bytes: ByteArray): String {
//        if (bytes == null) return null
        val len = bytes.size
        if (len <= 0) return ""
        val ret = CharArray(len shl 1)
        var i = 0
        var j = 0
        while (i < len) {
            ret[j++] = hexDigits[bytes[i].toInt().ushr(4) and 0x0f]
            ret[j++] = hexDigits[bytes[i].toInt() and 0x0f]
            i++
        }
        return String(ret)
    }

}