package com.ydl.ydlcommon.data.http.params

/**
 * Created by xj on 2019/8/14.
 */

internal class BaiduActionDataBean private constructor(builder: Builder) {

    /**
     * pkname APP包名
     * deviceType 设备类型  1代表IOS;2代表安卓
     * deviceId 设备ID 安卓:IMEI 号取 md5sum 摘要 IOS:IDFA 号取 md5sum 摘要
     * convertType 转化类型，每次选择一个类型回传，模型可用的转化类型请以推广后台新建转化追踪披露的转化类型为准 目前支持的转化类型枚举 激活：4 注册：25 付费：26
     * convertTime 转化时间，unix时间戳（精确到秒)，范围：一月以内
     * appid IOS APP Store ID
     * appName 应用名称
     * ip 	ipv4地址
     * ipv6 ipv6地址
     * tp 手机型号
     * network 网络环境: 0：无法探知或无网络 1：蜂窝数据接入，未知网络类型 2：2G 3：3G 4：4G 5：5G 100：wifi 101：以太网接入
     * androidId 	ANDROID_ID 取md5sum 摘要
     * convertParam 转化扩展参数，可用于客户自定义去重，传值格式例如:{"outer_action_id":"123"}；后台会根据outer_action_id的值结合转化类型进行去重，如果该字段未传值，默认按照7天进行数据去重
     */


    var pkname: String? = null
    var deviceType: Int = 2
    var deviceId: String? = null
    var convertType: Int = 0
    var convertTime: Long = 0.toLong()
    var appid: Long = 0.toLong()
    var appName: String? = null
    var ip: String? = null
    var ipv6: String? = null
    var tp: String? = null
    var network: Int = 0
    var androidId: String? = null
    var convertParam: String? = null
    var uid : String? = null
    var channel : String? = null

    init {
        this.pkname = builder.pkname
        this.deviceType = builder.deviceType
        this.deviceId = builder.deviceId
        this.convertType = builder.convertType
        this.convertTime = builder.convertTime
        this.appid = builder.appid
        this.appName = builder.appName
        this.ip = builder.ip
        this.ipv6 = builder.ipv6
        this.tp = builder.tp
        this.network = builder.network
        this.androidId = builder.androidId
        this.convertParam = builder.convertParam
        this.uid = builder.uid
        this.channel = builder.channel
    }

    class Builder {
        internal var pkname: String? = ""
        internal var deviceType: Int = 2
        internal var deviceId: String? = ""
        internal var convertType: Int = 0
        internal var convertTime: Long = 0.toLong()
        internal var appid: Long = 0.toLong()
        internal var appName: String? = ""
        internal var ip: String? = ""
        internal var ipv6: String? = ""
        internal var tp: String? = ""
        internal var network: Int = 0
        internal var androidId: String? = ""
        internal var convertParam: String? = ""
        internal var uid : String? = ""
        internal var mac : String? = ""
        internal var channel : String? = ""

        fun pkname(pkname: String = ""): Builder {
            this.pkname = pkname
            return this
        }

        fun deviceType(deviceType: Int = 0): Builder {
            this.deviceType = deviceType
            return this
        }

        fun deviceId(deviceId: String = ""): Builder {
            this.deviceId = deviceId
            return this
        }

        fun convertType(convertType: Int = 0): Builder {
            this.convertType = convertType
            return this
        }

        fun convertTime(convertTime: Long = 0.toLong()): Builder {
            this.convertTime = convertTime
            return this
        }

        fun appid(appid: Long = 0.toLong()): Builder {
            this.appid = appid
            return this
        }

        fun appName(appName: String = ""): Builder {
            this.appName = appName
            return this
        }

        fun ip(ip: String = ""): Builder {
            this.ip = ip
            return this
        }

        fun ipv6(ipv6: String = ""): Builder {
            this.ipv6 = ipv6
            return this
        }

        fun tp(tp: String = ""): Builder {
            this.tp = tp
            return this
        }

        fun network(network: Int = 0): Builder {
            this.network = network
            return this
        }

        fun androidId(androidId: String = ""): Builder {
            this.androidId = androidId
            return this
        }

        fun convertParam(convertParam: String = ""): Builder {
            this.convertParam = convertParam
            return this
        }

        fun uid(uid : String? = "") : Builder {
            this.uid = uid
            return this
        }
        fun mac(mac : String? = "") : Builder {
            this.mac = mac
            return this
        }

        fun channel(channel : String? = "") : Builder {
            this.channel = channel
            return this
        }
    }
}