package com.ydl.ydlcommon.ui

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.RelativeLayout
import com.bumptech.glide.Glide
import com.ydl.ydlcommon.R
import kotlinx.android.synthetic.main.platform_logo_loading_view.view.*

/**
 * Created by xj on 2019/7/26.
 */
class LogoLoadingView(context: Context?, attrs: AttributeSet?): RelativeLayout(context, attrs) {

    var DEFAULT_TYPE = TYPE_LOADING
    var mListener: LogoLoadingListener? = null

    companion object {
        const val TYPE_LOADING = 1 //加载中
        const val TYPE_NET_LOSS = 2 //无网络
        const val TYPE_DATA_SET = 3 //正常加载完成
    }

    init {
        initView()
    }

    private fun initView() {
        View.inflate(context, R.layout.platform_logo_loading_view,this)

        Glide.with(context).load(R.drawable.platform_loading_logo).into(logo_loading_gif)

        reset_btn.setOnClickListener {
            mListener?.onDataResetClick()
        }

        back_btn.setOnClickListener {
            mListener?.onBackClick()
        }
    }

    fun setListener(listener: LogoLoadingListener) {
        mListener = listener
    }

    //设置页面状态
    fun setViewType(type: Int, msg: String?) {
        DEFAULT_TYPE = type
        when (DEFAULT_TYPE) {
            TYPE_LOADING -> {
                logo_loading_gif_rl.visibility = View.VISIBLE
                empty_rl.visibility = View.GONE
                loading_rl.visibility = View.VISIBLE
            }
            TYPE_NET_LOSS -> {
                logo_loading_gif_rl.visibility = View.GONE
                empty_rl.visibility = View.VISIBLE
                loading_rl.visibility = View.VISIBLE
                msg?.let {
                    hint_msg.text = msg
                }
            }
            TYPE_DATA_SET -> {
                logo_loading_gif_rl.visibility = View.GONE
                empty_rl.visibility = View.GONE
                loading_rl.visibility = View.GONE
            }
        }
    }

    interface LogoLoadingListener {
        fun onDataResetClick()
        fun onBackClick()
    }
}