package com.ydl.ydlcommon.utils;


import android.text.TextUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 用户信息更新
 * 跟新到云信数据库
 * Created by Wi1ls on 2016/9/22;
 * update by harvie on 2017/7/22
 */
public class UserInfoCache {
    private static final Map<String,YDLUser> users=new HashMap<>();
    private static  UserInfoCache instance;


    public Map<String,YDLUser> getUsers(){
        return users;
    }

    public static UserInfoCache getInstance(){
        if(instance==null){
            synchronized (UserInfoCache.class){
                if(instance==null){
                    instance=new UserInfoCache();
                }
            }
        }
        return instance;
    }

    public YDLUser getUser(String uid){
        YDLUser user= users.get(uid);
        if(user!=null){
            return user;
        }
        else{
            return new YDLUser(uid,"","");
        }
    }

    public void saveYDLUser(String uid,String nickName,String avatar){
        if(users.get(uid)!=null&&users.get(uid).getAvatar()!=null&&!TextUtils.isEmpty(users.get(uid).getAvatar())){
            return;
        }

        users.put(uid,new YDLUser(uid,nickName,avatar));
    }

    public static class YDLUser{
        private String uid;
        private String nickName;
        private String avatar;

        public YDLUser(String uid, String nickName, String avatar) {
            this.uid = uid;
            this.nickName = nickName;
            this.avatar = avatar;
        }

        public String getUid() {
            return uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public String getNickName() {
            return nickName==null?"":nickName;
        }

        public void setNickName(String nickName) {
            this.nickName = nickName;
        }

        public String getAvatar() {
            return avatar;
        }

        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }
    }
}
